% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cue_validity.R
\name{cueAccuracy}
\alias{cueAccuracy}
\title{Calculate the accuracy of using a cue to predict a criterion.}
\usage{
cueAccuracy(criterion, cue, replaceNanWith = 0.5)
}
\arguments{
\item{criterion}{A vector of values to be predicted.}

\item{cue}{A vector of values to predict with.  Should have the same
length as the criterion.}

\item{replaceNanWith}{The value to return as cue validity in case it
cannot be calculated, e.g. no variance in the values.}
}
\value{
The cue accuracy, a value in the range [0,1].
}
\description{
\code{\link{cueValidity}} counts only correct and incorrect inferences,
ignoring cases where a cue does not discriminate.  Cue accuracy gives those
cases a weight of 0.5, the expected accuracy of guessing.
It is calculated as
(correct + 0.5 * guesses) / (correct + incorrect + guesses).
}
\examples{
cueValidity(c(5,1), c(1,0))
cueAccuracy(c(5,1), c(1,0))
# Both return 1.
cueValidity(c(5,2,1), c(1,0,0))
cueAccuracy(c(5,2,1), c(1,0,0))
# Cue validity still returns 1 but cue accuracy returns (2+0.5)/3 = 0.833.
}
\seealso{
\code{\link{cueValidity}} for an alternate measure used in Take The Best.
}
