% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexbinFull.R
\name{hexbinFull}
\alias{hexbinFull}
\title{Hexagonal binning with whole grid output.}
\usage{
hexbinFull(
  x,
  y = NULL,
  xbins = 128,
  shape = NULL,
  xbnds = range(x),
  ybnds = range(y),
  xlab = NULL,
  ylab = NULL,
  IDs = FALSE,
  weight = NULL
)
}
\arguments{
\item{x, y}{Coords of the points or a single plotting structure to be used in binning. See xy.coords.}

\item{xbins}{Number of bins in a row.}

\item{shape}{shape = yheight/xwidth of the plotting regions}

\item{xbnds, ybnds}{Horizontal and vertical limits of the binning region in x or y units respectively, must encompass range(x) or range(y) respectively; Vector of length 2}

\item{xlab, ylab}{Optional character strings used as labels for x and y. If NULL, sensible defaults are used.}

\item{IDs}{Logical indicating if the hexagonal cell ID for each point should be returned, see hexbin.}

\item{weight}{Numeric weight vector to be assigned to points.}
}
\value{
an S4 object of class \link[hexbin]{hexbin}.
}
\description{
Adapted from \link[hexbin]{hexbin} to output hexagons with 0 count, and also 
to allow points with different weights. Default to use regular hexagon. See 
\link[hexbin]{hexbin} for extra detail on the output.
}
\examples{
set.seed(133)
d=hexbinFull(x=rnorm(20000),y=rnorm(20000),xbins=50)
plotHexDensity(d)

}
\references{
Carr, D. B. et al. (1987) Scatterplot Matrix Techniques for Large 
N. JASA 83, 398, 424--436.
}
\author{
Dan Carr <dcarr@voxel.galaxy.gmu.edu>; ported and extended by 
Nicholas Lewin-Koh <nikko@hailmail.net>. Modified by Quoc Hoang Nguyen 
<nguyen.q@wehi.edu.au> for hexDensity.
}
