% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_quad_xy_to_icosa_tri}
\alias{hexify_quad_xy_to_icosa_tri}
\title{Convert Quad XY to Icosa Triangle coordinates}
\usage{
hexify_quad_xy_to_icosa_tri(quad, quad_x, quad_y)
}
\arguments{
\item{quad}{Quad number (0-11)}

\item{quad_x}{Continuous X coordinate in quad space}

\item{quad_y}{Continuous Y coordinate in quad space}
}
\value{
List with components:
\item{icosa_triangle_face}{Triangle face number (0-19)}
\item{icosa_triangle_x}{X coordinate on triangle face}
\item{icosa_triangle_y}{Y coordinate on triangle face}
}
\description{
Inverse transformation from quad coordinates back to icosahedral
triangle coordinates. Useful for projecting cell centers back to lon/lat.
}
\examples{
# Convert quad XY back to triangle coordinates
tri <- hexify_quad_xy_to_icosa_tri(quad = 1, quad_x = 0.5, quad_y = 0.3)
print(tri)
}
\seealso{
Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
