% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov-mix-wt.R
\name{cov.mix.wt}
\alias{cov.mix.wt}
\title{weighted covariance}
\usage{
cov.mix.wt(
  x,
  wt1 = rep(1/nrow(x), nrow(x)),
  wt2 = rep(1/nrow(x), nrow(x)),
  cor = FALSE,
  center = TRUE,
  method = c("unbiased", "ML")
)
}
\arguments{
\item{x}{the observation matrix}

\item{wt1}{the state probabilities matrix (number of observations
times number of states)}

\item{wt2}{the mixture components probabilities list (of length
nstate) of matrices (number of observations times number of
mixture components)}

\item{cor}{logical. if TRUE the weighted correlation is also given}

\item{center}{logical. if TRUE the weighted mean is also given}

\item{method}{with two possible entries:
\itemize{
\item \code{"unbiased"}{ the unbiased estimator is given}
\item \code{"ML"}{ the maximum likelihood estimator is given}
}}
}
\value{
list of emission (mixture multivariate normal) parameters:
(\code{mu}, \code{sigma} and \code{mix.p})
}
\description{
The weighted means and variances using the
observation matrix and the estimated weight vectors
}
\examples{
data(CMAPSS)
n = nrow(CMAPSS$train$x)
wt1 = matrix(runif(3*n),nrow=n,ncol=3)
wt2 = list()
for(j in 1:3) wt2[[j]] = matrix(runif(5*n),nrow=n,ncol=5)
emission = mixmvnorm_mstep(CMAPSS$train$x, wt1, wt2)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}, Afarin Bayat, \email{aftbayat@gmail.com}
}
