% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele-topn.R
\name{CalAlleleTopN}
\alias{CalAlleleTopN}
\title{topN most frequent HLA alleles}
\usage{
CalAlleleTopN(dat_in, nms_don = c(), nms_rcpt = c(), top_n = 5)
}
\arguments{
\item{dat_in}{A data frame with clean HLA typing data.}

\item{nms_don}{A vector of donor's allele name(s).}

\item{nms_rcpt}{A vector of recipient's allele name(s).}

\item{top_n}{Number of alleles to return. Default is 5.}
}
\value{
A tibble of top_n most frequent alleles.
}
\description{
Input cleaned HLA(Human Leukocyte Antigen) data for a population of transplant donors and recipients to determine the most common alleles represented in the population.
}
\examples{
dat <- read.csv(system.file("extdata/example", "HLA_MisMatch_test.csv", package = "hlaR"))
don <- c("donor.a1", "donor.a2")
rcpt <- c("recipient.a1", "recipient.a2")
re <- CalAlleleTopN(dat_in = dat, nms_don = don, nms_rcpt = rcpt, top_n = 2)
}
