% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{diagplots.hmclearn}
\alias{diagplots.hmclearn}
\title{Diagnostic plots for \code{hmclearn}}
\usage{
\method{diagplots}{hmclearn}(
  object,
  burnin = NULL,
  plotfun = 2,
  comparison.theta = NULL,
  cols = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{hmclearn}, usually a result of a call to \code{mh} or \code{hmc}}

\item{burnin}{optional numeric parameter for the number of initial MCMC samples to omit from the summary}

\item{plotfun}{integer 1 or 2 indicating which plots to display.  1 shows trace plots.  2 shows a histogram}

\item{comparison.theta}{optional numeric vector of parameter values to compare to the Bayesian estimates}

\item{cols}{optional integer index indicating which parameters to display}

\item{...}{currently unused}
}
\value{
Returns a customized \code{ggplot} object
}
\description{
Plots histograms of the posterior estimates.  Optionally, displays the 'actual'
values given a simulated dataset.
}
\examples{
# Linear regression example
set.seed(522)
X <- cbind(1, matrix(rnorm(300), ncol=3))
betavals <- c(0.5, -1, 2, -3)
y <- X\%*\%betavals + rnorm(100, sd=.2)

f <- hmc(N = 1000,
          theta.init = c(rep(0, 4), 1),
          epsilon = 0.01,
          L = 10,
          logPOSTERIOR = linear_posterior,
          glogPOSTERIOR = g_linear_posterior,
          varnames = c(paste0("beta", 0:3), "log_sigma_sq"),
          param=list(y=y, X=X), parallel=FALSE, chains=1)

diagplots(f, burnin=300, comparison.theta=c(betavals, 2*log(.2)))

}
