% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_validator.R
\name{cv.hmlasso}
\alias{cv.hmlasso}
\title{Fit a model using a design matrix with cross validation}
\usage{
cv.hmlasso(X, y, nfolds = 10, lambda.min.ratio = 0.01, nlambda = 100,
  lambda = NULL, foldid = NULL, unit = "sample", seed = 0,
  min_eig_th = 1e-06, use = "pairwise.complete.obs",
  impute_method = "mean", direct_prediction = FALSE,
  adjust_by_tr = FALSE, positify = "diag", weight_power = 1,
  mu = 1, eig_tol = 1e-08, eig_maxitr = 1e+08, verbose = FALSE,
  ...)
}
\arguments{
\item{X}{matrix of explanatory variables}

\item{y}{vector of objective variable}

\item{nfolds}{the number of folds (ignored if foldid is specified)}

\item{lambda.min.ratio}{ratio of max lambda and min lambda (ignored if lambda is specified)}

\item{nlambda}{the number of lambda (ignored if lambda is specified)}

\item{lambda}{lambda sequence}

\item{foldid}{vector indicating id of fold for each sample}

\item{unit}{unit for cross validation error: "sample" (default) or "fold"}

\item{seed}{random seed of cross validation}

\item{min_eig_th}{minimum eigenvalue}

\item{use}{method to calculate correlation matrix from missing data (default "pairwise.complete.obs")}

\item{impute_method}{imputation method for predictions}

\item{direct_prediction}{either corrected cross validation is used or not}

\item{adjust_by_tr}{whether mean (or median) of training data for prediction is used or not}

\item{positify}{method for solving PSD matrix}

\item{weight_power}{weighting power (default 0 meaning no-weighting)}

\item{mu}{augmented Lagrangian parameter}

\item{eig_tol}{tol parameter in eigs_sym function}

\item{eig_maxitr}{maxitr parameter in eigs_sym}

\item{verbose}{whether output verbose warnings and messages (default FALSE)}

\item{...}{parameters of hmlasso function}
}
\value{
lasso model
\item{fit}{lasso model with hole data}
\item{lambda.min}{lambda with minimum cross validation error}
\item{lambda.min.index}{index of lambda.min}
\item{lambda.1se}{largest lambda such that error is within 1 standard error of the minimum}
\item{lambda.1se.index}{index of lambda.1se}
\item{foldid}{fold id}
\item{cve}{cross validation error}
\item{cvse}{cross validation standard error}
\item{cvup}{cross validation error + standard error}
\item{cvlo}{cross validation error - standard error}
\item{pe}{prediction error (for family="binomial")}
}
\description{
Fit a model using a design matrix with cross validation
}
\examples{
X_incompl <- as.matrix(iris[, 1:3])
X_incompl[1:5,1] <- NA
X_incompl[6:10,2] <- NA
y <- iris[, 4]
cv_fit <- cv.hmlasso(X_incompl, y, nlambda=50, lambda.min.ratio=1e-2)
plot(cv_fit)
plot(cv_fit$fit)

}
