% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{lower}
\alias{lower}
\title{Lower Bound}
\usage{
lower(kvars)
}
\arguments{
\item{kvars}{a named vector giving the lower bounds. The names should correspond to the names
of the covariates in the model matrix.}
}
\value{
A holistic generalized model constraint, object inheriting from class \code{"hglmc"}.
}
\description{
Set a lower bound on the coefficients of specific covariates.
}
\examples{
dat <- rhglm(100, c(1, 2, -3, 4, 5, -6))
constraints <- lower(c(x2 = 0, x5 = 1))
hglm(y ~ ., constraints = constraints, data = dat)

# non-negative least squares
dat <- rhglm(100, c(1, 2, -3, 4, 5, -6))
constraints <- lower(setNames(double(5), paste0("x", 1:5)))
hglm(y ~ ., constraints = constraints, data = dat)
}
\seealso{
Other Constraint-Constructors: 
\code{\link{group_equal}()},
\code{\link{group_inout}()},
\code{\link{group_sparsity}()},
\code{\link{include}()},
\code{\link{k_max}()},
\code{\link{linear}()},
\code{\link{pairwise_sign_coherence}()},
\code{\link{rho_max}()},
\code{\link{sign_coherence}()},
\code{\link{upper}()}
}
\concept{Constraint-Constructors}
