\name{dplot}

\alias{dplot}

\title{function to make a pseudo-color image of a distance matrix with the row and column ordering based on HOPACH clustering results.}

\description{
The \code{hopach} clustering function orders the elements being clustered. This ordering can be used to rearrange the rows and columns in the corresponding distance matrix. A pseudo-color image of the ordered distance matrix will reveal the underlying patterns in the clustered data.

     The functions 'heat.colors', 'terrain.colors' and 'topo.colors'
     create heat-spectrum (red to white) and topographical color
     schemes suitable for displaying ordered data, with 'n' giving the
     number of colors desired.
}

\usage{
dplot(dist, hopachobj, ord = "final", col = heat.colors(12), main = NULL, 
xlab = NULL, ylab = NULL, labels = NULL, showclusters = TRUE, ...)
}

\arguments{
  \item{dist}{matrix of all pair wise distances between a set of 'p' elements, 
	as produced, for example, by the \code{distancematrix} function. 
	The value in row 'j' and column 'i' is the distance between element 'i'
 	and element 'j'. The matrix must be symmetric. The distance metric should be
	the same as that used in the \code{hopach} function.}
  \item{hopachobj}{output of the \code{hopach} function.}
  \item{ord}{character string indicating which of the two orderings produced by \code{hopach} should be used for the plot. If ord="final", the ordering of elements in the final level of the hierarchical tree is used. If ord="cluster", the ordering from the level of the tree corresponding to the main clusters is used. In both cases, the elements from each cluster will be contiguous. If ord="final", then the medoid element will appear in the middle of each cluster. Else, the ordering depends on the value of \code{ord} passed to the \code{hopach} function. If ord="none", then the elements are plotted in the same order as in dist.}
  \item{col}{ a list of colors such as that generated by 'rainbow', 'heat.colors', 'topo.colors', 'terrain.colors' or similar functions.}
  \item{main}{character string to be used as the main title}
  \item{xlab}{character string to be used as the horizontal axis label. If NULL, the label will be "" (no label).}
  \item{ylab}{character string to be used as the vertical axis label. If NULL, the label will be "" (no label).}
  \item{labels}{a vector of labels for the elements being clustered to be used on the axes. If labels=NULL, no axes are plotted - this is useful when there are a large number of elements being plotted.}
  \item{showclusters}{indicator of whether or not to show the cluster boundaries on the plot. If show.clusters=TRUE, dotted lines are drawn at the edges of the clusters.}
  \item{\dots}{additional arguments to the \code{image} plotting function}
}

\references{

van der Laan, M.J. and Pollard, K.S. A new algorithm for hybrid hierarchical clustering with visualization and the bootstrap. Journal of Statistical Planning and Inference, 2003, 117, pp. 275-303.

\url{http://www.stat.berkeley.edu/~laan/Research/Research_subpages/Papers/hopach.pdf}
}

\author{Katherine S. Pollard <kpollard@gladstone.ucsf.edu> and Mark J. van der Laan <laan@stat.berkeley.edu>}

\note{Thank you to Sandrine Dudoit <sandrine@stat.berkeley.edu> for her input.}

\seealso{\code{\link{distancematrix}}, \code{\link{hopach}}, \code{\link{image}}}

\examples{
mydata<-matrix(rnorm(50),nrow=10)
mydist<-distancematrix(mydata,d="euclid")
clustresult<-hopach(mydata,dmat=mydist)
dplot(mydist,clustresult,showclusters=FALSE)
dplot(mydist,clustresult,col=topo.colors(15))

}

\keyword{cluster}
\keyword{multivariate}

