% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingheterogeneity.R
\name{getCutPoints}
\alias{getCutPoints}
\title{Calculate the threshold cut-points and individual adjusted responses using Jurges' method}
\usage{
getCutPoints(model, decreasing.levels = TRUE, subset = NULL,
  plotf = TRUE, mar = c(4, 4, 1, 1), oma = c(0, 0, 0, 0),
  XLab = "Health index", XLab.cex = 1.1, YLab = "Counts",
  YLab.cex = 1.1, group.labels.type = c("middle", "border", "none"))
}
\arguments{
\item{model}{a fitted \code{hopit} model.}

\item{decreasing.levels}{a logical indicating whether self-reported health classes are ordered in decreasing order.}

\item{subset}{an optional vector specifying a subset of observations.}

\item{plotf}{a logical indicating whether to plot the results.}

\item{mar, oma}{graphic parameters, see \code{\link{par}}.}

\item{XLab, XLab.cex}{a label of the x axis and it's size.}

\item{YLab, YLab.cex}{a label of the y axis and it's size.}

\item{group.labels.type}{position of the legend. One of \code{middel}, \code{border}, or \code{none}.}
}
\value{
a list with the following components:
\item{cutpoints}{ cut-points for the adjusted categorical response levels with the corresponding percentiles of the latent index.}
\item{adjusted.levels}{ adjusted categorical response levels for each individual.}
}
\description{
Calculate the threshold cut-points and individual adjusted responses using Jurges' method
}
\examples{
# DATA
data(healthsurvey)

# the order of response levels decreases from the best health to
# the worst health; hence the hopit() parameter decreasing.levels
# is set to TRUE
levels(healthsurvey$health)

# Example 1 ---------------------

# fit a model
model1 <- hopit(latent.formula = health ~ hypertension + high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese + diabetes + other_diseases,
              thresh.formula = ~ sex + ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

# calculate the health index cut-points
z <- getCutPoints(model = model1)
z$cutpoints

# tabulate the adjusted health levels for individuals: Jurges method
rev(table(z$adjusted.levels))

# tabulate the original health levels for individuals
table(model1$y_i)

# tabulate the predicted health levels
table(model1$Ey_i)
}
\references{
\insertRef{Jurges2007}{hopit}\cr\cr
\insertRef{OKSUZYAN2019}{hopit}
}
\seealso{
\code{\link{latentIndex}}, \code{\link{standardiseCoef}}, \code{\link{getLevels}}, \code{\link{hopit}}.
}
\author{
Maciej J. Danko
}
