% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/graphs.R
\name{n.most.frequent.terms}
\alias{n.most.frequent.terms}
\title{Select most frequently annotated terms from a set of phenotypes}
\usage{
n.most.frequent.terms(hpo.terms, terms, plotting.context, n)
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{terms}{Character vector of HPO terms}

\item{plotting.context}{List object with hpo.phenotypes slot for list of character vectors of terms}

\item{n}{Integer}
}
\value{
Character vector of length at most \code{n}
}
\description{
Select most frequently annotated terms from a set of phenotypes
}
\examples{
data(hpo.terms)
n.most.frequent.terms(hpo.terms, c("HP:0001873"),
	list(hpo.phenotypes=list("HP:0001873", "HP:0001902")), n=2)
}
\seealso{
\code{\link{remove.terms.with.less.than.n.occurrences}}, \code{\link{remove.uninformative.for.plot}}
}

