% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootCRCumInc.R
\name{bootCRCumInc}
\alias{bootCRCumInc}
\title{Bootstrap for Ratios of Hazard Ratios}
\usage{
bootCRCumInc(
  df,
  exit,
  event,
  exposure,
  entry = NULL,
  weights = NULL,
  ipwvars = NULL,
  rep = 0,
  print.attr = T,
  seed = 54321
)
}
\arguments{
\item{df}{A data frame containing, at a minimum, exit, event, and exposure.}

\item{exit}{Name of the column in df containing times of event or censoring.}

\item{event}{Name of the column in df containing codes for censoring (0) and event types (1-4). Analysis of more than 4 competing events is not supported by this function.}

\item{exposure}{Name of the column in df containing a binary (0/1) exposure variable for stratification.}

\item{entry}{Name of the column in df containing late entry times.}

\item{weights}{Name of the column in df containing user-supplied weights. If ipwvars is utilized, this argument is ignored.}

\item{ipwvars}{A vector of names of columns in `df` containing predictor variables for building a propensity score model for exposure and creating standardized inverse probability weights using this model. Overrides the weights argument.}

\item{rep}{Number of replicates for bootstrapping if confidence intervals for the sHR/csHR estimate are desired. See more details on bootstrapping below.}

\item{print.attr}{A `TRUE/FALSE`` statement if results needed to be returned in console.}

\item{seed}{A seed number start for the bootstrap estimation.}
}
\value{
A data frame with the 95% confidence interval limits (upper and lower) for
Sub-hazard ratio/Cause-specific hazard ratio for each event:

\code{R1.lower}     Lower limit of the 95%CI of the Sub-hazard ratio/Cause-specific hazard ratio for event 1 at time \code{t}.

\code{R1.upper}     Upper limit of the 95%CI of the Sub-hazard ratio/Cause-specific hazard ratio for event 1 at time \code{t}

\code{R2.lower}     Lower limit of the 95%CI of the Sub-hazard ratio/Cause-specific hazard ratio for event 2 at time \code{t}

\code{R2.upper}     Upper limit of the 95%CI of the Sub-hazard ratio/Cause-specific hazard ratio for event 2 at time \code{t}
}
\description{
Bootstrap 95% Confidence Intervals limits for estimated Ratios of sHR/csHR.
}
\examples{
#data from the package
data <- hrcomprisk::dat_ckid
#Obtain the 95\%CI by bootstraping
ciCIF<-bootCRCumInc(df=data, exit=exit, event=event, exposure=b1nb0, rep=10, print.attr=TRUE)
}
