% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H2_overall.R
\name{h2_overall}
\alias{h2_overall}
\alias{h2_overall.default}
\alias{h2_overall.hstats}
\title{Overall Interaction Strength}
\usage{
h2_overall(object, ...)

\method{h2_overall}{default}(object, ...)

\method{h2_overall}{hstats}(
  object,
  normalize = TRUE,
  squared = TRUE,
  sort = TRUE,
  top_m = 15L,
  zero = TRUE,
  eps = 1e-08,
  plot = FALSE,
  fill = "#2b51a1",
  ...
)
}
\arguments{
\item{object}{Object of class "hstats".}

\item{...}{Further parameters passed to \code{geom_bar()}.}

\item{normalize}{Should statistics be normalized? Default is \code{TRUE}.}

\item{squared}{Should \emph{squared} statistics be returned? Default is \code{TRUE}.}

\item{sort}{Should results be sorted? Default is \code{TRUE}.
(Multioutput is sorted by row means.)}

\item{top_m}{How many rows should be shown? (\code{Inf} to show all.)}

\item{zero}{Should rows with all 0 be shown? Default is \code{TRUE}.}

\item{eps}{Threshold below which numerator values are set to 0.}

\item{plot}{Should results be plotted as barplot? Default is \code{FALSE}.}

\item{fill}{Color of bar (only for univariate statistics).}
}
\value{
A matrix of statistics (one row per variable, one column per prediction dimension),
or a "ggplot" object (if \code{plot = TRUE}).
}
\description{
Friedman and Popescu's statistic of overall interaction strength per
feature, see Details. Set \code{plot = TRUE} to plot the results as barplot.
}
\details{
The logic of Friedman and Popescu (2008) is as follows:
If there are no interactions involving feature \eqn{x_j}, we can decompose the
(centered) prediction function \eqn{F} into the sum of the (centered) partial
dependence \eqn{F_j} on \eqn{x_j} and the (centered) partial dependence
\eqn{F_{\setminus j}} on all other features \eqn{\mathbf{x}_{\setminus j}}, i.e.,
\deqn{
  F(\mathbf{x}) = F_j(x_j) + F_{\setminus j}(\mathbf{x}_{\setminus j}).
}
Correspondingly, Friedman and Popescu's statistic of overall interaction
strength is given by
\deqn{
  H_j^2 = \frac{\frac{1}{n} \sum_{i = 1}^n\big[F(\mathbf{x}_i) - 
  \hat F_j(x_{ij}) - \hat F_{\setminus j}(\mathbf{x}_{i\setminus j})
  \big]^2}{\frac{1}{n} \sum_{i = 1}^n\big[F(\mathbf{x}_i)\big]^2}
}
(check \code{\link[=partial_dep]{partial_dep()}} for all definitions).

\strong{Remarks:}
\enumerate{
\item Partial dependence functions (and \eqn{F}) are all centered to
(possibly weighted) mean 0.
\item Partial dependence functions (and \eqn{F}) are evaluated over the data distribution.
This is different to partial dependence plots, where one uses a fixed grid.
\item Weighted versions follow by replacing all arithmetic means by corresponding
weighted means.
\item Multivariate predictions can be treated in a component-wise manner.
\item Due to (typically undesired) extrapolation effects of partial dependence functions,
depending on the model, values above 1 may occur.
\item \eqn{H^2_j = 0} means there are no interactions associated with \eqn{x_j}.
The higher the value, the more prediction variability comes from interactions
with \eqn{x_j}.
\item Since the denominator is the same for all features, the values of the test
statistics can be compared across features.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{h2_overall(default)}: Default method of overall interaction strength.

\item \code{h2_overall(hstats)}: Overall interaction strength from "hstats" object.

}}
\examples{
# MODEL 1: Linear regression
fit <- lm(Sepal.Length ~ . + Petal.Width:Species, data = iris)
s <- hstats(fit, X = iris[-1])
h2_overall(s)
h2_overall(s, plot = TRUE)

# MODEL 2: Multi-response linear regression
fit <- lm(as.matrix(iris[1:2]) ~ Petal.Length + Petal.Width * Species, data = iris)
s <- hstats(fit, X = iris[3:5], verbose = FALSE)
h2_overall(s, plot = TRUE, zero = FALSE)
}
\references{
Friedman, Jerome H., and Bogdan E. Popescu. \emph{"Predictive Learning via Rule Ensembles."}
The Annals of Applied Statistics 2, no. 3 (2008): 916-54.
}
\seealso{
\code{\link[=hstats]{hstats()}}, \code{\link[=h2]{h2()}}, \code{\link[=h2_pairwise]{h2_pairwise()}}, \code{\link[=h2_threeway]{h2_threeway()}}
}
