% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_station.R
\name{d_station}
\alias{d_station}
\title{Create, Modify or Remove a station}
\usage{
d_station(
  db.sqlite,
  op = "C",
  sta = NA,
  name_st = NA,
  name_fld = NA,
  value_fld = NA,
  bku = TRUE
)
}
\arguments{
\item{db.sqlite}{Full name of the data base}

\item{op}{Create (default), Modify or Remove C/M/R}

\item{sta}{Station id}

\item{name_st}{Station name}

\item{name_fld}{List of field names}

\item{value_fld}{list of field values}

\item{bku}{Automatic Backup TRUE (default) / FALSE}
}
\value{
Station created, modified ou removed from the data base
}
\description{
Create, Modify or Remove a station in a tshm data base
}
\details{
If op is C, the fields Id_Station (sta) and
Nom (name_st) are compulsory. The field Nom (name_st) can be modified afterwards.

If op is C or M, the following fields can be completed :
Ordre = as.character(NA), Type_Station = as.character(type_st),
Id_Station = as.character(sta), Id_Secondaire = as.character(NA),
Id_Tertiaire = as.character(NA), Type_Meteo = as.character(NA),
Nom = as.character(name_st), Pays = as.character(NA),
Zone = as.character(NA), SousZone = as.character(NA),
GrandBassin = as.character(NA), Bassin = as.character(NA),
PetitBassin = as.character(NA), Riviere = as.character(NA),
Gestionnaire = as.character(NA), Latitude = as.numeric(NA),
Longitude = as.numeric(NA), Altitude = as.numeric(NA),
Superficie_bv = as.numeric(NA), Mois_Debut_Hydro = as.numeric(NA),
Debut_Activite = as.numeric(NA), Activite = as.logical(NA),
Critere_OuiNon = as.logical(NA), Critere_OuiNon2 = as.logical(NA),
Critere_Numerique = as.numeric(NA), Critere_Texte = as.character(NA),
Nom_Observateur = as.character(NA), Adresse = as.character(NA),
Teletransmission = as.logical(NA), Enregistreur = as.logical(NA),
Fictive = as.logical(NA),
Commentaire = as.character(NA), Flag = as.logical(NA),
District = as.character(NA), Localite = as.character(NA)

If op is M, station type and station id cannot be modified. The sensor
data corresponding to the station are conserved.

If op is R, all data and sensors of the station are removed.
}
\seealso{
\itemize{
 \item \code{\link{d_inventory}} or \code{\link{d_invent}} for exploring the
 data base content;
 \item \code{\link{d_exphts}} for extracting a time-series;
 \item \code{\link{d_table}} for creating a data base and/or creating/removing
 a table ;
 \item \code{\link{d_sensor}} for creating, modifying or removing a sensor.
}
}
\author{
P. Chevallier - Jan 2018-Jan 2019
}
