% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_set.R
\name{z_set}
\alias{z_set}
\title{Edit settings}
\usage{
z_set(
  file.names = file.names,
  plot.label = "label",
  line.type = 1,
  line.width = 0.2,
  point.shape = 15,
  point.size = 8,
  title = "Title",
  yaxis = "y-Axis",
  normval = FALSE,
  fixtime = FALSE,
  begin = today(),
  end = today(),
  fixy = FALSE,
  ymin = as.numeric(NA),
  ymax = as.numeric(NA),
  trend = FALSE,
  facet = FALSE,
  point.plot = FALSE,
  tz = "UTC",
  palette = "ggplot2"
)
}
\arguments{
\item{file.names}{character, compulsory list of file names to be plotted (no default)}

\item{plot.label}{character, list of labels for each plot (default = "label" [i])}

\item{line.type}{integer in the interval [0-6] (default = 1)}

\item{line.width}{numeric, width (in point unit) of the line (default = 0.2)}

\item{point.shape}{integer in the interval [0-25] (default = 20)}

\item{point.size}{numeric, size of the plotted points (in point unit) (default = 8)}

\item{title}{character, plot title (default="Title")}

\item{yaxis}{character, label of the y-Axis (default="y-Axis)}

\item{normval}{logical, normalizes the plotted value (default = FALSE)}

\item{fixtime}{logical, set a time interval (default = FALSE)}

\item{begin}{"YYYY-MM-DD" or date function, beginning time (default = today())}

\item{end}{"YYYY-MM-DD" or date function, ending time (default = today())}

\item{fixy}{logical, set limits on the y-Axis (default=FALSE)}

\item{ymin}{numeric, min limit on the Y-Axis (default = NA)}

\item{ymax}{numeric, max limit on the Y-Axis (default = NA)}

\item{trend}{logical, overlays a linear trend line (default = FALSE)}

\item{facet}{logical, shows a facet plot (default = FALSE)}

\item{point.plot}{logical, shows points on the plot (default = FALSE)}

\item{tz}{character, time zone (default="UTC")}

\item{palette}{character, palette (default="ggplot2")}
}
\value{
A file "settings.RData" in the working directory
}
\description{
Utility for editing the settings of a plotting operation.
}
\details{
tz is a time zone included in the Olson list.

palette is a list of colors chosen in the palette.pals list.
}
\author{
P. Chevallier - nov 2018 - aug 2023
}
