% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bmiage}
\alias{bmiage}
\title{CDC BMI-for-age charts}
\format{A data.table object with variables \describe{
\item{\code{Sex}}{'Male' or 'Female'} 
 \item{\code{Agemos}}{Age in months}
 \item{\code{L}, 
 \code{M}, \code{S}}{LMS parameters; see 
 \url{https://www.cdc.gov/growthcharts/percentile_data_files.htm}} 
 \item{\code{P3}, 
 \code{P5}, \code{P10}, \code{P25}, \code{P50}, \code{P75}, \code{P85}, 
 \code{P90}, \code{P95}, and \code{P97}}{BMI percentiles}}}
\source{
\url{http://www.cdc.gov/growthcharts/percentile_data_files.htm}
}
\usage{
bmiage
}
\description{
Charts giving the BMI-for-age percentiles for boys and girls ages 2-18
}
\details{
For children ages 2 to 18, weight class depends on the BMI-for-age percentile.
\describe{
\item{Underweight}{<5th percentile}
\item{Normal weight}{5th-85th percentile}
\item{Overweight}{85th-95th percentile}
\item{Obese}{>=95th percentile}
}
}
\references{
Ring, Caroline L., et al. "Identifying populations sensitive to 
environmental chemicals by simulating toxicokinetic variability." Environment 
International 106 (2017): 105-118
}
\author{
Caroline Ring
}
\keyword{data}
\keyword{httk-pop}
