% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_analytic_css.R
\name{calc_analytic_css}
\alias{calc_analytic_css}
\title{Calculate the analytic steady state concentration.}
\usage{
calc_analytic_css(chem.name = NULL, chem.cas = NULL,
  parameters = NULL, daily.dose = 1, output.units = "uM",
  model = "pbtk", species = "Human", concentration = "plasma",
  suppress.messages = F, recalc.blood2plasma = F,
  default.to.human = F, tissue = NULL, well.stirred.correction = T,
  adjusted.Funbound.plasma = T, regression = T,
  restrictive.clearance = T, IVIVE = NULL, ...)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters must 
be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must 
be specified.}

\item{parameters}{Chemical parameters from parameterize_pbtk (for model = 
'pbtk'), parameterize_3comp (for model = '3compartment), 
parmeterize_1comp(for model = '1compartment') or parameterize_steadystate 
(for model = '3compartmentss'), overrides chem.name and chem.cas.}

\item{daily.dose}{Total daily dose, mg/kg BW.}

\item{output.units}{Units for returned concentrations, defaults to uM 
(specify units = "uM") but can also be mg/L.}

\item{model}{Model used in calculation, 'pbtk' for the multiple compartment 
model,'3compartment' for the three compartment model, '3compartmentss' for 
the three compartment steady state model, and '1compartment' for one 
compartment model.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or 
default "Human").}

\item{concentration}{Desired concentration type, 'blood' or default 'plasma'.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{recalc.blood2plasma}{Recalculates the ratio of the amount of chemical 
in the blood to plasma using the input parameters, calculated with hematocrit,
Funbound.plasma, and Krbc2pu.}

\item{default.to.human}{Substitutes missing rat values with human values if 
true.}

\item{tissue}{Desired tissue conentration, overwrites concentration 
argument.}

\item{well.stirred.correction}{Uses correction in calculation of hepatic 
clearance for well-stirred model if TRUE for model 1compartment and 
3compartmentss. This assumes clearance relative to amount unbound in whole 
blood instead of plasma, but converted to use with plasma concentration.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to 
TRUE along with partition coefficients calculated with this value.}

\item{restrictive.clearance}{If TRUE (default), then only the fraction of
chemical not bound to protein is available for metabolism in the liver. If 
FALSE, then all chemical in the liver is metabolized (faster metabolism due
to rapid off-binding).}

\item{IVIVE}{Honda et al. (submitted) identified six plausible sets of 
assumptions for \emph{in vitro-in vivo} extrapolation (IVIVE) assumptions. 
Argument may be set to "Honda1" through "Honda6". If used, this function 
overwrites the tissue, restrictive.clearance, and plasma.binding arguments. 
See Details below for more information.}

\item{...}{Additional parameters passed to parameterize functions if parameters is NULL.}

\item{regression}{Whether}{or not to use the regressions in calculating 
partition coefficients.}
}
\value{
Steady state concentration                                                               %'      #'
}
\description{
This function calculates the analytic steady state plasma or venous blood 
concentrations as a result of infusion dosing for the three compartment and 
multiple compartment PBTK models.
}
\details{
Tissue concentrations are calculated for the pbtk model with oral 
infusion dosing.  All tissues other than gut, liver, and lung are the product
of the steady state plasma concentration and the tissue to plasma partition 
coefficient. 
\tabular{lrrrr}{
\tab \emph{in vivo} Conc. \tab Metabolic Clearance \tab Bioactive Chemical Conc. \tab TK Statistic Used* \cr
Honda1 \tab Veinous (Plasma) \tab Restrictive \tab Free \tab Mean Conc. \cr
Honda2 \tab Veinous \tab Restrictive \tab Free \tab Max Conc. \cr
Honda3 \tab Veinous \tab Non-restrictive \tab Total \tab Mean Conc. \cr
Honda4 \tab Veinous \tab Non-restrictive \tab Total \tab Max Conc. \cr
Honda5 \tab Target Tissue \tab Non-restrictive \tab Total \tab Mean Conc. \cr
Honda6 \tab Target Tissue \tab Non-restrictive \tab Total \tab Max Conc. \cr
}
*Assumption is currently ignored because analytical steady-state solutions are currently used by this function.
}
\examples{
calc_analytic_css(chem.name='Bisphenol-A',output.units='mg/L',
                 model='3compartment',concentration='blood')
calc_analytic_css(chem.name='Bisphenol-A',tissue='liver',species='rabbit',
                 default.to.human=TRUE,daily.dose=2)
calc_analytic_css(chem.name="bisphenol a",model="1compartment")
calc_analytic_css(chem.cas="80-05-7",model="3compartmentss")
params <- parameterize_pbtk(chem.cas="80-05-7") 
calc_analytic_css(parameters=params,model="pbtk")

}
\references{
Honda, Gregory S., et al. "Using the Concordance of In Vitro and 
In Vivo Data to Evaluate Extrapolation Assumptions", submitted.
}
\author{
Robert Pearce and John Wambaugh
}
\keyword{Solve}
