% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_chemtable.R
\name{augment.table}
\alias{augment.table}
\title{Add a paramter value to the chem.physical_and_invitro.data table}
\usage{
augment.table(
  this.table,
  this.CAS,
  compound.name = NULL,
  this.property,
  value,
  species = NULL,
  reference,
  overwrite = F,
  sig.fig = 4,
  clint.pvalue.overwrite = T,
  allow.na = F
)
}
\arguments{
\item{this.table}{Object of class data.frame containing one row per chemical.}

\item{this.CAS}{The Chemical Abstracts Service registry number (CAS-RN)
correponding to the parameter value}

\item{compound.name}{A name associated with the chemical (defaults to NULL)}

\item{this.property}{The property being added/modified.}

\item{value}{The value being assigned to this.property.}

\item{species}{This is the species for the data in the new table. This may
be omitted if a column in data.list gives the species value for each
chemical or if the data are not species-specific (e.g., MW).}

\item{reference}{This is the reference for the data in the new table. This
may be omitted if a column in data.list gives the reference value for each
chemical.}

\item{overwrite}{If overwrite=TRUE then data in current.table will be
replaced by any data in new.table that is for the same chemical and
property. If overwrite=FALSE (DEFAULT) then new data for the same chemical
and property are ignored.  Funbound.plasma values of 0 (below limit of
detection) are overwritten either way.}

\item{sig.fig}{Sets the number of significant figures stored (defaults to 4)}

\item{clint.pvalue.overwrite}{If TRUE then the Cl_int p-value is set to NA 
when the Cl_int value is changed unless a new p-value is provided. (defaults
to TRUE)}

\item{allow.na}{If TRUE (default is FALSE) then NA values are written to the
table, otherwise they are ignored.}
}
\value{
\item{data.frame}{A new data.frame containing the data in
current.table augmented by new.table}
}
\description{
This internal function is used by \code{\link{add_chemtable}} to add a single 
new parameter to the table of chemical parameters. It should not be typically
used from the command line.
}
\author{
John Wambaugh
}
