% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-header.R
\name{expect_header}
\alias{expect_header}
\title{Test that an HTTP request is made with a header}
\usage{
expect_header(...)
}
\arguments{
\item{...}{Arguments passed to \code{expect_warning}}
}
\value{
\code{NULL}, according to \code{expect_warning}.
}
\description{
This expectation checks that a HTTP header (and potentially header value)
is present in a request. It works by inspecting the request object and
raising warnings that are caught by \code{\link[testthat:expect_warning]{testthat::expect_warning()}}.
}
\details{
\code{expect_header} works both in the mock HTTP contexts and on "live" HTTP
requests.
}
\examples{
library(httr)
with_fake_http({
    expect_header(GET("http://example.com", config=add_headers(Accept="image/png")),
        "Accept: image/png")
})
}
