% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/oauth-token.r
\name{oauth_service_token}
\alias{oauth_service_token}
\title{Generate OAuth token for service accounts.}
\usage{
oauth_service_token(endpoint, secrets, scope = NULL)
}
\arguments{
\item{endpoint}{An OAuth endpoint, created by \code{\link{oauth_endpoint}}}

\item{secrets}{Secrets loaded from JSON file, downloaded from console.}

\item{scope}{a character vector of scopes to request.}
}
\description{
Service accounts provide a way of using OAuth2 without user intervention.
They instead assume that the server has access to a private key used
to sign requests. The OAuth app is not needed for service accounts:
that information is embedded in the account itself.
}
\examples{
\dontrun{
endpoint <- oauth_endpoints("google")
secrets <- jsonlite::fromJSON("~/Desktop/httrtest-45693cbfac92.json")
scope <- "https://www.googleapis.com/auth/bigquery.readonly"

token <- oauth_service_token(endpoint, secrets, scope)
}
}
\seealso{
Other OAuth: \code{\link{oauth1.0_token}};
  \code{\link{oauth2.0_token}}; \code{\link{oauth_app}};
  \code{\link{oauth_endpoint}}
}

