% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curl.R
\name{curl_translate}
\alias{curl_translate}
\alias{curl_help}
\title{Translate curl syntax to httr2}
\usage{
curl_translate(cmd)

curl_help()
}
\arguments{
\item{cmd}{Call to curl. If omitted and the clipr package is installed,
will be retrieved from the clipboard.}
}
\value{
A string containing the translated httr2 code. If the input
was copied from the clipboard, the translation will be copied back
to the clipboard.
}
\description{
The curl command line tool is commonly used to demonstrate HTTP APIs and can
easily be generated from
\href{https://everything.curl.dev/usingcurl/copyas}{browser developer tools}.
\code{curl_translate()} saves you the pain of manually translating these calls
by implementing a partial, but frequently used, subset of curl options.
Use \code{curl_help()} to see the supported options, and \code{curl_translate()}
to translate a curl invocation copy and pasted from elsewhere.

Inspired by \href{https://github.com/hrbrmstr/curlconverter}{curlconverter}
written by \href{https://rud.is/b/}{Bob Rudis}.
}
\examples{
curl_translate("curl http://example.com")
curl_translate("curl http://example.com -X DELETE")
curl_translate("curl http://example.com --header A:1 --header B:2")
curl_translate("curl http://example.com --verbose")
}
