% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-perform.R
\name{req_perform}
\alias{req_perform}
\title{Perform a request to get a response}
\usage{
req_perform(
  req,
  path = NULL,
  verbosity = NULL,
  mock = getOption("httr2_mock", NULL),
  error_call = current_env()
)
}
\arguments{
\item{req}{A \link{request}.}

\item{path}{Optionally, path to save body of the response. This is useful
for large responses since it avoids storing the response in memory.}

\item{verbosity}{How much information to print? This is a wrapper
around \code{\link[=req_verbose]{req_verbose()}} that uses an integer to control verbosity:
\itemize{
\item \code{0}: no output
\item \code{1}: show headers
\item \code{2}: show headers and bodies
\item \code{3}: show headers, bodies, and curl status messages.
}

Use \code{\link[=with_verbosity]{with_verbosity()}} to control the verbosity of requests that
you can't affect directly.}

\item{mock}{A mocking function. If supplied, this function is called
with the request. It should return either \code{NULL} (if it doesn't want to
handle the request) or a \link{response} (if it does). See \code{\link[=with_mock]{with_mock()}}/
\code{local_mock()} for more details.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
\itemize{
\item If the HTTP request succeeds, and the status code is ok (e.g. 200),
an HTTP \link{response}.
\item If the HTTP request succeeds, but the status code is an error
(e.g a 404), an error with class \code{c("httr2_http_404", "httr2_http")}.
By default, all 400 and 500 status codes will be treated as an error,
but you can customise this with \code{\link[=req_error]{req_error()}}.
\item If the HTTP request fails (e.g. the connection is dropped or the
server doesn't exist), an error with class \code{"httr2_failure"}.
}
}
\description{
After preparing a \link{request}, call \code{req_perform()} to perform it, fetching
the results back to R as a \link{response}.

The default HTTP method is \code{GET} unless a body (set by \link{req_body_json} and
friends) is present, in which case it will be \code{POST}. You can override
these defaults with \code{\link[=req_method]{req_method()}}.
}
\section{Requests}{
Note that one call to \code{req_perform()} may perform multiple HTTP requests:
\itemize{
\item If the \code{url} is redirected with a 301, 302, 303, or 307, curl will
automatically follow the \code{Location} header to the new location.
\item If you have configured retries with \code{\link[=req_retry]{req_retry()}} and the request
fails with a transient problem, \code{req_perform()} will try again after
waiting a bit. See \code{\link[=req_retry]{req_retry()}} for details.
\item If you are using OAuth, and the cached token has expired, \code{req_perform()}
will get a new token either using the refresh token (if available)
or by running the OAuth flow.
}
}

\section{Progress bar}{
\code{req_perform()} will automatically add a progress bar if it needs to wait
between requests for \code{\link[=req_throttle]{req_throttle()}} or \code{\link[=req_retry]{req_retry()}}. You can turn the
progress bar off (and just show the total time to wait) by setting
\code{options(httr2_progress = FALSE)}.
}

\examples{
request("https://google.com") |>
  req_perform()
}
\seealso{
\code{\link[=req_perform_parallel]{req_perform_parallel()}} to perform multiple requests in parallel.
\code{\link[=req_perform_iterative]{req_perform_iterative()}} to perform multiple requests iteratively.
}
