% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_niveaux_nappes.R
\name{get_niveaux_nappes_stations}
\alias{get_niveaux_nappes_stations}
\alias{get_niveaux_nappes_chroniques}
\alias{get_niveaux_nappes_chroniques_tr}
\title{Retrieve data from API "Piézométrie"}
\usage{
get_niveaux_nappes_stations(...)

get_niveaux_nappes_chroniques(...)

get_niveaux_nappes_chroniques_tr(...)
}
\arguments{
\item{...}{parameters of the queries and their values in the format
\verb{Param1_Name = "Param1 value", Param2_Name = "Param2 value"}, use the
function \link{list_params} for a list of the available filter parameters
for a given API endpoint and see the API documentation for their description}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row by record and one column by field.
}
\description{
The available endpoints are:
\itemize{
\item \code{get_niveaux_nappes_stations} retrieves list of piezometric stations
\item \code{get_nappes_chroniques} retrieves piezometric archived time series
\item \code{get_nappes_chroniques_tr} retrieves piezometric "real time" data
}

See the API documentation for available filter parameters: \url{https://hubeau.eaufrance.fr/page/api-piezometrie}
}
\examples{
\dontrun{
# Retrieve the hydrometric stations in the department of Aube
get_niveaux_nappes_stations(code_departement = "10")

# Retrieve the archived observed piezometric level at station '07548X0009/F' (old BSS identifier)
# for the year 2020
df <- get_niveaux_nappes_chroniques(code_bss = "07548X0009/F",
                                      date_debut_mesure = "2020-01-01",
                                      date_fin_mesure = "2020-12-31")

# Plot the water elevation (NGF)
plot(as.POSIXct(df$date_mesure), df$niveau_nappe_eau, type = "l")

# For retrieving the last real time observed piezometric level
# at station 'BSS001VZGZ' (new BSS identifier)
df <- get_niveaux_nappes_chroniques_tr(bss_id = "BSS001VZGZ")

# Plot the water elevation (NGF)
plot(as.POSIXct(df$date_mesure), df$niveau_eau_ngf, type = "l")
}
}
