% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/include_text.R
\name{include_text}
\alias{include_text}
\title{Text layer}
\usage{
include_text(
  label,
  value,
  position = NA,
  size = 11,
  font = NA,
  type = "static",
  color = NA,
  angle = 0,
  opts = NA
)
}
\arguments{
\item{label}{label output}

\item{value}{column or string}

\item{position}{position coordinate}

\item{size}{text size}

\item{font}{font type}

\item{type}{type of entry: dynamic or static}

\item{color}{image color}

\item{angle}{angle of the text}

\item{opts}{list arguments from draw_label()}
}
\value{
data frame
}
\description{
Insert text in label
}
\examples{

\donttest{

library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
       , "1q0EZmZBt52ca-0VbididjJy2jXTwf06laJpzvkQJWvc/edit#gid=107939497")
fb <- gsheet2tbl(url)

label <- label_layout(data = fb
               , size = c(10, 2.5)
               ) \%>\%
         include_image(value = "https://inkaverse.com/reference/figures/logo.png"
               , size = c(2,2)
               , position = "1.2*1.25"
               ) \%>\%
         include_text(value = "plots", position = "5*1.25") \%>\% 
         label_print()

}

}
