% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{bottom_border}
\alias{bottom_border}
\alias{bottom_border<-}
\alias{set_bottom_border}
\alias{bottom_border.huxtable}
\alias{bottom_border<-.huxtable}
\title{Get or Set Bottom Border}
\usage{
bottom_border(ht)
bottom_border(ht) <- value
set_bottom_border(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric vector or matrix giving border widths. Set to 0 for no border. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{bottom_border}, the \code{bottom_border} attribute.
For \code{set_bottom_border}, the \code{ht} object.
}
\description{
Functions to get or set the bottom border property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
bottom_border(ht) <-  1
bottom_border(ht)
print_screen(ht)
}
\seealso{
Other borders: \code{\link{left_border}},
  \code{\link{right_border}}, \code{\link{top_border}}
}
