% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{rotation}
\alias{rotation}
\alias{rotation<-}
\alias{set_rotation}
\alias{rotation.huxtable}
\alias{rotation<-.huxtable}
\title{Get or Set Cell Text Rotation}
\usage{
rotation(ht)
rotation(ht) <- value
set_rotation(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric vector. 0 is normal direction, 90 is going up, etc. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{rotation}, the \code{rotation} attribute.
For \code{set_rotation}, the \code{ht} object.
}
\description{
Functions to get or set the cell text rotation property of huxtable table cells.
}
\details{
You will likely need to set \code{\link{col_width}} and \code{\link{row_height}} explicitly
to achieve a nice result, in both HTML and LaTeX.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
rotation(ht) <-  90
rotation(ht)

}
