% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping-functions.R
\name{by_rows}
\alias{by_rows}
\alias{by_cols}
\title{Set cell properties by row or column}
\usage{
by_rows(..., from = 1, ignore_na = TRUE)

by_cols(..., from = 1, ignore_na = TRUE)
}
\arguments{
\item{...}{One or more cell property values.}

\item{from}{Numeric. Row or column to start at.}

\item{ignore_na}{If \code{TRUE}, \code{NA} values in the result will be left unchanged. Otherwise, \code{NA}
normally resets to the default.}
}
\value{
A function for use in \code{map_***} functions.
}
\description{
\code{by_rows} and \code{by_cols} set properties in horizontal or vertical "stripes".
}
\examples{
ht <- as_hux(matrix(rnorm(25), 5, 5))
map_background_color(ht,
      by_rows("green", "grey"))
map_background_color(ht,
      by_cols("green", "grey"))
}
\seealso{
\link{mapping-functions}

Other mapping functions: \code{\link{by_cases}},
  \code{\link{by_colorspace}}, \code{\link{by_function}},
  \code{\link{by_quantiles}}, \code{\link{by_ranges}},
  \code{\link{by_regex}}, \code{\link{by_values}}
}
\concept{mapping functions}
