% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huxreg.R
\name{tidy_override}
\alias{tidy_override}
\alias{tidy.tidy_override}
\alias{glance.tidy_override}
\alias{nobs.tidy_override}
\title{Override a model's \code{tidy} output}
\usage{
tidy_override(x, ..., glance = list(), extend = FALSE)

\method{tidy}{tidy_override}(x, ...)

\method{glance}{tidy_override}(x, ...)

\method{nobs}{tidy_override}(object, ...)
}
\arguments{
\item{x}{A model with methods defined for \code{\link[broom:tidy]{broom::tidy()}} and/or \code{\link[broom:glance]{broom::glance()}}.}

\item{...}{In \code{tidy_override}, columns of statistics to replace \code{tidy} output. In
\code{tidy} and \code{glance} methods, arguments passed on to the underlying model.}

\item{glance}{A list of summary statistics for \code{glance}.}

\item{extend}{Logical: allow adding new statistics?}

\item{object}{A \code{tidy_override} object.}
}
\value{
An object of class "tidy_override". When \code{tidy} and \code{glance} are called
on this, it will return results from the underlying model, replacing some
columns with your own data.
}
\description{
Use \code{tidy_override} to provide your own p values, confidence intervals
etc. for a model.
}
\examples{
if (! requireNamespace("broom")) {
  stop("Please install 'broom' to run this example.")
}

lm1 <- lm(mpg ~ cyl, mtcars)
fixed_lm1 <- tidy_override(lm1,
      p.value = c(.04, .12),
      glance = list(r.squared = 0.99))

broom::tidy(fixed_lm1)

cbind(huxreg(fixed_lm1), huxreg(lm1))
}
