% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flood1.R
\name{flood1}
\alias{flood1}
\title{Function to compute flood extent or flood duration \code{SpatRaster}
along the German federal waterways Elbe and Rhine using the 1d water level
algorithm \code{hyd1d::waterLevelFlood1()}}
\usage{
flood1(x, seq, gauging_station, uuid, filename = "", ...)
}
\arguments{
\item{x}{has to be type \code{SpatRaster} and has to include both input
layers \code{csa} (cross section areas) and \code{dem} (digital
elevation model). To compute water levels along the River Elbe, \code{x}
has to be in the coordinate reference system
\href{https://spatialreference.org/ref/epsg/25833/}{ETRS 1989 UTM 33N},
for the River Rhine in
\href{https://spatialreference.org/ref/epsg/25832/}{ETRS 1989 UTM 32N}.
Other coordinate reference systems are not permitted.}

\item{seq}{has to be type \code{c("POSIXct", "POSIXt")} or \code{Date} and
have a length larger than 0. Values of \code{seq} must be in the
temporal range between 1960-01-01 and yesterday (\code{Sys.Date() - 1}).
Internally \code{\link[hyd1d]{waterLevelFlood1}} uses \code{\link[hyd1d]{getGaugingDataW}}
to obtain daily water level information from \code{\link[hyd1d]{df.gauging_data}}.}

\item{gauging_station}{has to be type \code{character} and has to have a
length of one. Permitted values are: 'SCHOENA', 'PIRNA', 'DRESDEN',
'MEISSEN', 'RIESA', 'MUEHLBERG', 'TORGAU', 'PRETZSCH-MAUKEN', 'ELSTER',
'WITTENBERG', 'COSWIG', 'VOCKERODE', 'ROSSLAU', 'DESSAU', 'AKEN', 'BARBY',
'SCHOENEBECK', 'MAGDEBURG-BUCKAU', 'MAGDEBURG-STROMBRUECKE',
'MAGDEBURG-ROTHENSEE', 'NIEGRIPP AP', 'ROGAETZ', 'TANGERMUENDE', 'STORKAU',
'SANDAU', 'SCHARLEUK', 'WITTENBERGE', 'MUEGGENDORF', 'SCHNACKENBURG',
'LENZEN', 'GORLEBEN', 'DOEMITZ', 'DAMNATZ', 'HITZACKER', 'NEU DARCHAU',
'BLECKEDE', 'BOIZENBURG', 'HOHNSTORF', 'ARTLENBURG', 'GEESTHACHT',
'RHEINWEILER', 'BREISACH', 'RUST', 'OTTENHEIM', 'KEHL-KRONENHOF',
'IFFEZHEIM', 'PLITTERSDORF', 'MAXAU', 'PHILIPPSBURG', 'SPEYER', 'MANNHEIM',
'WORMS', 'NIERSTEIN-OPPENHEIM', 'MAINZ', 'OESTRICH', 'BINGEN', 'KAUB',
'SANKT GOAR', 'BOPPARD', 'BRAUBACH', 'KOBLENZ', 'ANDERNACH', 'OBERWINTER',
'BONN', 'KOELN', 'DUESSELDORF', 'RUHRORT', 'WESEL', 'REES', 'EMMERICH'.}

\item{uuid}{has to be type \code{character} and has to have a length of one.
Permitted values are: '7cb7461b-3530-4c01-8978-7f676b8f71ed',
'85d686f1-55b2-4d36-8dba-3207b50901a7',
'70272185-b2b3-4178-96b8-43bea330dcae',
'24440872-5bd2-4fb3-8554-907b49816c49',
'b04b739d-7ffa-41ee-9eb9-95cb1b4ef508',
'16b9b4e7-be14-41fd-941e-6755c97276cc',
'83bbaedb-5d81-4bc6-9f66-3bd700c99c1f',
'f3dc8f07-c2bb-4b92-b0b0-4e01a395a2c6',
'c093b557-4954-4f05-8f5c-6c6d7916c62d',
'070b1eb4-3872-4e07-b2e5-e25fd9251b93',
'1ce53a59-33b9-40dc-9b17-3cd2a2414607',
'ae93f2a5-612e-4514-b5fd-9c8aecdd73c7',
'e97116a4-7d30-4671-8ba1-cdce0a153d1d',
'1edc5fa4-88af-47f5-95a4-0e77a06fe8b1',
'094b96e5-caeb-46d3-a8ee-d44182add069',
'939f82ec-15a9-49c8-8828-dc2f8a2d49e2',
'90bcb315-f080-41a8-a0ac-6122331bb4cf',
'b8567c1e-8610-4c2b-a240-65e8a74919fa',
'ccccb57f-a2f9-4183-ae88-5710d3afaefd',
'e30f2e83-b80b-4b96-8f39-fa60317afcc7',
'3adf88fd-fd7a-41d0-84f5-1143c98a6564',
'133f0f6c-2ca1-4798-9360-5b5f417dd839',
'13e91b77-90f3-41a5-a320-641748e9c311',
'de4cc1db-51cb-4b62-bee2-9750cbe4f5c4',
'f4c55f77-ab80-4e00-bed3-aa6631aba074',
'e32b0a28-8cd5-4053-bc86-fff9c6469106',
'cbf3cd49-91bd-49cc-8926-ccc6c0e7eca4',
'48f2661f-f9cb-4093-9d57-da2418ed656e',
'550e3885-a9d1-4e55-bd25-34228bd6d988',
'c80a4f21-528c-4771-98d7-10cd591699a4',
'ac507f42-1593-49ea-865f-10b2523617c7',
'6e3ea719-48b1-408a-bc55-0986c1e94cd5',
'c233674f-259a-4304-b81f-dce1f415d85b',
'a26e57c9-1cb8-4fca-ba80-9e02abc81df8',
'67d6e882-b60c-40d3-975c-a6d7a2b4e40a',
'6aa1cd8e-e528-4bcb-ba8e-705b6dcb7da2',
'33e0bce0-13df-4ffc-be9d-f1a79e795e1c',
'd9289367-c8aa-4b6a-b1ad-857fec94c6bb',
'b3492c68-8373-4769-9b29-22f66635a478',
'44f7e955-c97d-45c8-9ed7-19406806fb4c',
'06b978dd-8c4d-48ac-a0c8-2c16681ed281',
'9da1ad2b-88db-4cbb-8132-eddfab07d5ba',
'5389b878-fad5-4f37-bb87-e6cb36b7078b',
'787e5d63-61e2-48cc-acf0-633e2bf923f2',
'23af9b02-5c82-4f6e-acb8-f92a06e5e4da',
'b02be240-1364-4c97-8bb6-675d7d842332',
'6b774802-fcb5-49ae-8ecb-ecaf1a278b1c',
'b6c6d5c8-e2d5-4469-8dd8-fa972ef7eaea',
'88e972e1-88a0-4eb9-847c-0925e5999a46',
'2cb8ae5b-c5c9-4fa8-bac0-bb724f2754f4',
'57090802-c51a-4d09-8340-b4453cd0e1f5',
'844a620f-f3b8-4b6b-8e3c-783ae2aa232a',
'd28e7ed1-3317-41c5-bec6-725369ed1171',
'a37a9aa3-45e9-4d90-9df6-109f3a28a5af',
'665be0fe-5e38-43f6-8b04-02a93bdbeeb4',
'0309cd61-90c9-470e-99d4-2ee4fb2c5f84',
'1d26e504-7f9e-480a-b52c-5932be6549ab',
'550eb7e9-172e-48e4-ae1e-d1b761b42223',
'2ff6379d-d168-4022-8da0-16846d45ef9b',
'd6dc44d1-63ac-4871-b175-60ac4040069a',
'4c7d796a-39f2-4f26-97a9-3aad01713e29',
'5735892a-ec65-4b29-97c5-50939aa9584e',
'b45359df-c020-4314-adb1-d1921db642da',
'593647aa-9fea-43ec-a7d6-6476a76ae868',
'a6ee8177-107b-47dd-bcfd-30960ccc6e9c',
'8f7e5f92-1153-4f93-acba-ca48670c8ca9',
'c0f51e35-d0e8-4318-afaf-c5fcbc29f4c1',
'f33c3cc9-dc4b-4b77-baa9-5a5f10704398',
'2f025389-fac8-4557-94d3-7d0428878c86',
'9598e4cb-0849-401e-bba0-689234b27644'.}

\item{filename}{supplies an optional output filename and has to be type
\code{character}.}

\item{\dots}{additional arguments as for \code{\link[terra]{writeRaster}}.}
}
\value{
\code{SpatRaster} object with flood duration in the range of
\code{[0, length(seq)]}.
}
\description{
Computes flood extent, if \code{length(seq)} equals 1, or flood
duration for the active floodplains along the German federal waterways Elbe
and Rhine based on 1d water levels computed by
\code{\link[hyd1d]{waterLevelFlood1}} provided by package \pkg{hyd1d} in
analogy to the INFORM 3 module 'Flut1'.
}
\details{
For every time step provided in \code{seq}, \code{flood1()} computes
a 1d water level using \code{\link[hyd1d]{waterLevelFlood1}} along the
requested river section. This 1d water level is transfered to a \code{wl}
(water level) raster layer, which is in fact a copy of the \code{csa}
(cross section areas) layer, and then compared to the \code{dem}
(digital elevation model) layer. Where the \code{wl} layer is
higher than the \code{dem}, layer flood duration is increased by 1.
}
\examples{
\donttest{
  options("hydflood.datadir" = tempdir())
  library(hydflood)
  
  # import the raster data and create a raster stack
  c <- st_crs("EPSG:25833")
  e <- ext(309000, 310000, 5749000, 5750000)
  x <- hydSpatRaster(ext = e, crs = c)
  
  # create a temporal sequence
  seq <- seq(as.Date("2016-12-01"), as.Date("2016-12-31"), by = "day")
  
  # compute a flood duration
  fd <- flood1(x = x, seq = seq, gauging_station = "ROSSLAU")
}

}
\references{
\insertRef{rosenzweig_inform_2011}{hydflood}
}
\seealso{
\code{\link[hyd1d]{df.gauging_data}},
\code{\link[hyd1d]{getGaugingDataW}},
\code{\link[hyd1d]{waterLevelFlood1}},
\code{\link[terra]{writeRaster}},
\code{\link[terra]{terraOptions}}
}
