% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_network.R
\name{sort_network}
\alias{sort_network}
\alias{sort_network.data.frame}
\alias{sort_network.hy}
\title{Sort Network}
\usage{
sort_network(x, split = FALSE, outlets = NULL)

\method{sort_network}{data.frame}(x, split = FALSE, outlets = NULL)

\method{sort_network}{hy}(x, split = FALSE, outlets = NULL)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{split}{logical if TRUE, the result will be split into
independent networks identified by the id of their outlet. The
outlet id of each independent network is added as a "terminalid"
attribute.}

\item{outlets}{same as id in x. if specified, only the network
emanating from these outlets will be considered and returned.
NOTE: If outlets does not include all outlets from a given
network containing diversions, a partial network may be returned.}
}
\value{
data.frame containing a topologically sorted version
of the requested network and optionally a terminal id.
}
\description{
given a network with an id and and toid, returns a sorted
and potentially split set of output.

Can also be used as a very fast implementation of upstream
with tributaries navigation. The full network from each
outlet is returned in sorted order.

If a network includes diversions, all flowlines downstream of
the diversion are visited prior to continuing upstream. See
note on the \code{outlets} parameter for implications of this
implementation detail.
}
\examples{
x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

g <- add_toids(x)

head(g <- sort_network(g))

g$topo_sort <- nrow(g):1

plot(g['topo_sort'])

g <- add_toids(x, return_dendritic = FALSE)

g <- sort_network(g)

g$topo_sort <- nrow(g):1

plot(g['topo_sort'])

}
