% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/list2dataframe.R
\name{list2Dataframe}
\alias{list2Dataframe}
\title{Convert a list to a dataframe.}
\usage{
list2Dataframe(datalist)
}
\arguments{
\item{datalist}{A list containing different time series, each sub list has to have the same length.}
}
\value{
The converted dataframe
}
\description{
Convert a list of different time series to a dataframe. Usually the list is the output of
\code{extractPeriod}
NOTE: Since it's dataframe, so the dataframes in the input datalist should have the same
date, if not, please use  \code{extractPeriod} to process.
}
\examples{
# open file attached in the package.
file <- system.file("extdata", "testdl.txt", package = "hyfo")
datalist <- dget(file) # read list file.
datalist_new <- extractPeriod(datalist, commonPeriod = TRUE)

dataframe <- list2Dataframe(datalist_new)

# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}

