\name{ranktable}
\alias{ranktable}
\alias{ranktable_to_ordertable}
\alias{ordertable_to_ranktable}
\alias{wikitable_to_ranktable}
\alias{print.ranktablesummary}
\alias{ranktable_to_printable_object}
\alias{summary.ranktable}
\title{Convert rank tables to and from order tables}
\description{
  Convert rank tables (as generated by \code{rrank()}, for example) to
  order tables like the formula 1 tables; and convert back.  Print and
  summary methods for rank tables are documented here.  See also
  \code{ordertable.Rd}. 
}
\usage{
ranktable_to_ordertable(xrank)
ordertable_to_ranktable(xorder)
wikitable_to_ranktable(wikitable, strict=FALSE)
\method{summary}{ranktable}(object, ...)
ranktable_to_printable_object(x)
\method{print}{ranktablesummary}(x,...)
}
\arguments{
  \item{x,xrank,object}{A rank table, an object with class
    \code{ranktable}, for example the value of \code{rrank()}}
  \item{xorder,wikitable}{Order tables.  Argument \code{wikitable}
    refers to a generalized order table which can include entries such
    as DNF signifying did not finish.}
  \item{strict}{Controls for \code{wikitable_to_ranktable()}}
  \item{...}{Further arguments (currently ignored)}  
}
\details{
Function \code{ranktable_to_ordertable()} is trivial;
\code{ordertable_to_ranktable()} less so.  The prototype for order
tables would be \code{skating_table}. 

Function \code{ordertable_to_ranktable(x)} checks for each column being
a permutation of \code{seq_len(nrow(x))} and, if not, it stops.  In
particular, \acronym{DNF} entries are out of scope.  To convert order
tables such as \code{F1_table_2017}, which include \acronym{DNF}
entries, use \code{wikitable_to_ranktable()} or \code{ordertable2supp()}
to produce a likelihood function.

Function \code{ranktable_to_printable_object()} is a helper function
that coerces a \code{ranktable} object to a matrix that prints nicely.

The print method is discussed in vignette
\code{inst/ordertable_to_ranktable.Rmd}.

}
\value{An order table or rank table}
\author{Robin K. S. Hankin}
\seealso{
  \code{\link{rrank}},
  \code{\link{ordertable2supp}}
}
\examples{

p <- (5:1)/15
names(p) <- letters[1:5]
xrank <- rrank(12,p,rnames=month.abb)
xorder <- ranktable_to_ordertable(xrank)

## Can convert back and forth:
identical(xrank,ordertable_to_ranktable(ranktable_to_ordertable(xrank)))

# maxp(ordertable2supp(xorder))  # should be close to p
ordertable_to_ranktable(skating_table)
}
