% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl2i.R
\name{wl2i}
\alias{wl2i}
\alias{i2wl}
\title{Conversion between Wavelength and Spectra Matrix Column
Index \code{wl2i} returns the column indices for the spectra matrix for the given wavelengths.
\code{i2wl} converts column indices into wavelengths.}
\usage{
wl2i(x, wavelength = stop("wavelengths are required."))

i2wl(x, i)
}
\arguments{
\item{x}{a \code{hyperSpec} object}

\item{wavelength}{the wavelengths to be converted into column indices,
either numeric or a formula, see details.}

\item{i}{the column indices into the spectra matrix for which the
wavelength is to be computed}
}
\value{
A numeric containing the resulting indices for \code{wl2i}

\code{i2wl} returns a numeric with the wavelengths
}
\description{
If \code{wavelength} is numeric, each of its elements is converted to the respective index.
Values outside the range of \code{x@wavelength} become \code{NA}.
}
\details{
If the range is given as a formula (i.e. \code{start ~ end}, a sequence

index corresponding to start : index corresponding to end

is returned. If the wavelengths are not ordered, that may lead to chaos. In this case, call
\code{\link[hyperSpec]{orderwl}} first.

Two special variables can be used: \code{min} and \code{max}, corresponding to the lowest and
highest wavelength of \code{x}, respectively.

start and end may be complex numbers. The resulting index for a complex x is then

index (Re (x)) + Im (x)
}
\examples{

flu
wl2i (flu, 405 : 407)
wl2i (flu, 405 ~ 407)
  
## beginning of the spectrum to 407 nm 
wl2i (flu, min ~ 407)

## 2 data points from the beginning of the spectrum to 407 nm 
wl2i (flu, min + 2i ~ 407)

## the first 3 data points   
wl2i (flu, min ~ min + 2i)

## from 490 nm to end of the spectrum 
wl2i (flu, 490 ~ max)
  
## the last 8 data points 
wl2i (flu, max - 7i ~ max)
  
## get 450 nm +- 3 data points
wl2i (flu, 450 - 3i ~ 450 + 3i) 
  
wl2i (flu, 300 : 400) ## all NA: 
wl2i (flu, 600 ~ 700) ## NULL: completely outside flu's wavelength range

  
i2wl (chondro, 17:20)

}
\author{
C. Beleites
}
