% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spc.fit.poly.R
\name{spc.fit.poly}
\alias{spc.fit.poly}
\alias{spc.fit.poly.below}
\title{Polynomial Baseline Fitting
These functions fit polynomal baselines.}
\usage{
spc.fit.poly(fit.to, apply.to = NULL, poly.order = 1,
  offset.wl = !(is.null(apply.to)))

spc.fit.poly.below(fit.to, apply.to = fit.to, poly.order = 1,
  npts.min = max(round(nwl(fit.to) * 0.05), 3 * (poly.order + 1)),
  noise = 0, offset.wl = FALSE, max.iter = nwl(fit.to),
  stop.on.increase = FALSE, debuglevel = hy.getOption("debuglevel"))
}
\arguments{
\item{fit.to}{\code{hyperSpec} object on which the baselines are fitted}

\item{apply.to}{\code{hyperSpec} object on which the baselines are evaluted
If \code{NULL}, a \code{hyperSpec} object containing the polynomial
coefficients rather than evaluted baselines is returned.}

\item{poly.order}{order of the polynomial to be used}

\item{offset.wl}{should the wavelength range be mapped to -> [0, delta wl]?
This enhances numerical stability.}

\item{npts.min}{minimal number of points used for fitting the polynomial}

\item{noise}{noise level to be considered during the fit. It may be given
as one value for all the spectra, or for each spectrum separately.}

\item{max.iter}{stop at the latest after so many iterations.}

\item{stop.on.increase}{additional stopping rule: stop if the number of support points would increase, 
regardless whether npts.min was reached or not.}

\item{debuglevel}{additional output:
\code{1} shows \code{npts.min}, 
\code{2} plots support points for the final baseline of 1st spectrum, 
\code{3} plots support points for 1st spectrum,
\code{4} plots support points for all spectra.}
}
\value{
\code{hyperspec} object containing the baselines in the spectra
  matrix, either as polynomial coefficients or as polynomials evaluted on
  the spectral range of \code{apply.to}
}
\description{
Both functions fit polynomials to be used as baselines. If \code{apply.to}
is \code{NULL}, a \code{hyperSpec} object with the polynomial coefficients
is returned, otherwise the polynomials are evaluated on the spectral range
of \code{apply.to}.

\code{spc.fit.poly.below} tries to fit the baseline on appropriate spectral
ranges of the spectra in \code{fit.to}.  For details, see the
\code{vignette ("baseline")}.
}
\details{
\code{spc.fit.poly} calculates the least squares fit of order
\code{poly.order} to the \emph{complete} spectra given in \code{fit.to}.
Thus \code{fit.to} needs to be cut appropriately.
}
\examples{

\dontrun{vignette ("baseline", package = "hyperSpec")}

spc <- chondro [1 : 10]
baselines <- spc.fit.poly(spc [,, c (625 ~ 640, 1785 ~ 1800)], spc)
plot(spc - baselines)


baselines <- spc.fit.poly.below (spc)
plot (spc - baselines)

spc.fit.poly.below(chondro [1:3], debuglevel = 1)
spc.fit.poly.below(chondro [1:3], debuglevel = 2)
spc.fit.poly.below(chondro [1:3], debuglevel = 3, noise = sqrt (rowMeans (chondro [[1:3]])))

}
\seealso{
\code{vignette ("baseline", package = "hyperSpec")}

see \code{\link[hyperSpec]{options}} for more on \code{debuglevel}
}
\author{
C. Beleites
}
\concept{
baseline
}
\keyword{datagen}
\keyword{manip}
