% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARfit.R
\name{IARfit}
\alias{IARfit}
\title{Fitted Values of IAR model}
\usage{
IARfit(phi, y, st, standarized = T, include.mean = F)
}
\arguments{
\item{phi}{Estimated phi parameter by the iAR model.}

\item{y}{Array with the time series observations.}

\item{st}{Array with the irregular observational times.}

\item{standarized}{logical; if true, the array y is standarized; if false, y contains the raw time series}

\item{include.mean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}
}
\value{
Fitted values of the iAR model
}
\description{
Fit an IAR model to an irregularly observed time series.
}
\examples{

set.seed(6714)
st<-gentime(n=100)
y<-IARsample(phi=0.99,st=st,n=100)
y<-y$series
phi=IARloglik(y=y,st=st)$phi
fit=IARfit(phi=phi,y=y,st=st)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARsample}}, \code{\link{IARloglik}}, \code{\link{IARkalman}}
}
