% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{IARsample}
\alias{IARsample}
\title{Simulate from an IAR Model}
\usage{
IARsample(phi, st, n = 100L)
}
\arguments{
\item{phi}{A coefficient of IAR model. A value between 0 and 1}

\item{st}{Array with observational times.}

\item{n}{Length of the output time series. A strictly positive integer.}
}
\value{
A list with the following components:
\itemize{
\item{times}{ Array with observation times.}
\item{series}{ Array with simulated IAR data.}
}
}
\description{
Simulates an IAR Time Series Model.
}
\examples{

set.seed(6714)
st<-gentime(n=100)
y<-IARsample(phi=0.99,st=st, n=100)
y<-y$series
plot(st,y,type='l')
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}
}
