% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_attributions.R
\name{local_attributions}
\alias{local_attributions}
\alias{local_attributions.explainer}
\alias{local_attributions.default}
\title{Model Agnostic Sequential Variable attributions}
\usage{
local_attributions(x, ...)

\method{local_attributions}{explainer}(x, new_observation, keep_distributions = FALSE, ...)

\method{local_attributions}{default}(
  x,
  data,
  predict_function = predict,
  new_observation,
  label = class(x)[1],
  keep_distributions = FALSE,
  order = NULL,
  ...
)
}
\arguments{
\item{x}{an explainer created with function \code{\link[DALEX]{explain}} or a model.}

\item{...}{other parameters.}

\item{new_observation}{a new observation with columns that correspond to variables used in the model.}

\item{keep_distributions}{if \code{TRUE}, then distribution of partial predictions is stored and can be plotted with the generic \code{plot()}.}

\item{data}{validation dataset, will be extracted from \code{x} if it is an explainer.}

\item{predict_function}{predict function, will be extracted from \code{x} if it is an explainer.}

\item{label}{name of the model. By default it's extracted from the 'class' attribute of the model.}

\item{order}{if not \code{NULL}, then it will be a fixed order of variables. It can be a numeric vector or vector with names of variables.}
}
\value{
an object of the \code{break_down} class.
}
\description{
This function finds Variable attributions via Sequential Variable Conditioning.
The complexity of this function is O(2*p).
This function works in a similar way to step-up and step-down greedy approximations in function \code{\link{break_down}}.
The main difference is that in the first step the order of variables is determined.
And in the second step the impact is calculated.
}
\examples{
library("DALEX")
library("iBreakDown")
set.seed(1313)
model_titanic_glm <- glm(survived ~ gender + age + fare,
                       data = titanic_imputed, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic_imputed,
                           y = titanic_imputed$survived,
                           label = "glm")

bd_glm <- local_attributions(explain_titanic_glm, titanic_imputed[1, ])
bd_glm
plot(bd_glm, max_features = 3)

\dontrun{
## Not run:
library("randomForest")
set.seed(1313)
# example with interaction
# classification for HR data
model <- randomForest(status ~ . , data = HR)
new_observation <- HR_test[1,]

explainer_rf <- explain(model,
                        data = HR[1:1000,1:5])

bd_rf <- local_attributions(explainer_rf,
                           new_observation)
bd_rf
plot(bd_rf)
plot(bd_rf, baseline = 0)

# example for regression - apartment prices
# here we do not have interactions
model <- randomForest(m2.price ~ . , data = apartments)
explainer_rf <- explain(model,
                        data = apartments_test[1:1000,2:6],
                        y = apartments_test$m2.price[1:1000])

bd_rf <- local_attributions(explainer_rf,
                           apartments_test[1,])
bd_rf
plot(bd_rf, digits = 1)

bd_rf <- local_attributions(explainer_rf,
                           apartments_test[1,],
                           keep_distributions = TRUE)
plot(bd_rf, plot_distributions = TRUE)
}
}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema}
}
\seealso{
\code{\link{break_down}}, \code{\link{local_interactions}}
}
