% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F006.cell.filter.R
\name{cell.filter}
\alias{cell.filter}
\title{Filter cells}
\usage{
cell.filter(x = NULL, min.mito = 0, max.mito = 1, min.genes = 0,
  max.genes = Inf, min.umis = 0, max.umis = Inf,
  filter.by.cell.id = "character", keep.cell.id = "character",
  filter.by.gene = "character", filter.by.gene.exp.min = 1)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{min.mito}{Min rate for mitochondrial gene expression per cell, default = 0.}

\item{max.mito}{Max rate for mitochondrial gene expression per cell, default = 1.}

\item{min.genes}{Min number genes per cell, default = 0.}

\item{max.genes}{Max number genes per cell, default = Inf.}

\item{min.umis}{Min number UMIs per cell, default = 0.}

\item{max.umis}{Max number UMIs per cell, default = Inf.}

\item{filter.by.cell.id}{A character vector of cell ids to be filtered out.}

\item{keep.cell.id}{A character vector of cell ids to keep.}

\item{filter.by.gene}{A character vector of gene names to be filtered by thier expression. If more then one gene is defined it would be OR not AND.}

\item{filter.by.gene.exp.min}{Minimum gene expression to be filtered by the genes set in filter.by.gene, default = 1.}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and filters the raw data based on the number of UMIs, genes per cell, percentage of mitochondrial genes per cell, genes, gene expression and cell ids.
}
\examples{
demo.obj <- cell.filter(demo.obj,
                       min.mito = 0,
                       max.mito = 0.05 ,
                       min.genes = 100,
                       max.genes = 2500,
                       min.umis = 0,
                       max.umis = Inf)

message(demo.obj@my.filters)

}
