/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.io.Serializable;
import umontreal.iro.lecuyer.rng.CloneableRandomStream;
import umontreal.iro.lecuyer.util.PrintfFormat;

@Deprecated
public class RandMrg
implements CloneableRandomStream,
Serializable {
    private static final long serialVersionUID = 70510L;
    private static final double m1 = 4.294967087E9;
    private static final double m2 = 4.294944443E9;
    private static final double a12 = 1403580.0;
    private static final double a13n = 810728.0;
    private static final double a21 = 527612.0;
    private static final double a23n = 1370589.0;
    private static final double two17 = 131072.0;
    private static final double two53 = 9.007199254740992E15;
    private static final double invtwo24 = 5.960464477539063E-8;
    private static final double norm = 2.328306549295728E-10;
    private static final double[][] InvA1 = new double[][]{{1.84888585E8, 0.0, 1.945170933E9}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
    private static final double[][] InvA2 = new double[][]{{0.0, 3.60363334E8, 4.225571728E9}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
    private static final double[][] A1p0 = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {-810728.0, 1403580.0, 0.0}};
    private static final double[][] A2p0 = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {-1370589.0, 0.0, 527612.0}};
    private static final double[][] A1p76 = new double[][]{{8.2758667E7, 1.871391091E9, 4.127413238E9}, {3.672831523E9, 6.9195019E7, 1.871391091E9}, {3.672091415E9, 3.528743235E9, 6.9195019E7}};
    private static final double[][] A2p76 = new double[][]{{1.511326704E9, 3.759209742E9, 1.610795712E9}, {4.292754251E9, 1.511326704E9, 3.889917532E9}, {3.859662829E9, 4.292754251E9, 3.70846608E9}};
    private static final double[][] A1p127 = new double[][]{{2.427906178E9, 3.580155704E9, 9.49770784E8}, {2.26153695E8, 1.230515664E9, 3.580155704E9}, {1.988835001E9, 9.86791581E8, 1.230515664E9}};
    private static final double[][] A2p127 = new double[][]{{1.464411153E9, 2.77697599E8, 1.610723613E9}, {3.218393E7, 1.464411153E9, 1.022607788E9}, {2.824425944E9, 3.218393E7, 2.093834863E9}};
    private static double[] nextSeed = new double[]{12345.0, 12345.0, 12345.0, 12345.0, 12345.0, 12345.0};
    private double[] Cg = new double[6];
    private double[] Bg = new double[6];
    private double[] Ig = new double[6];
    private boolean anti = false;
    private boolean prec53 = false;
    private String descriptor;

    private static double multModM(double a, double s, double c, double m) {
        double d;
        int a1;
        double v = a * s + c;
        if (v >= 9.007199254740992E15 || v <= -9.007199254740992E15) {
            a1 = (int)(a / 131072.0);
            a -= (double)a1 * 131072.0;
            v = (double)a1 * s;
            a1 = (int)(v / m);
            v -= (double)a1 * m;
            v = v * 131072.0 + a * s + c;
        }
        a1 = (int)(v / m);
        v -= (double)a1 * m;
        if (d < 0.0) {
            return v += m;
        }
        return v;
    }

    private static void matVecModM(double[][] A, double[] s, double[] v, double m) {
        int i;
        double[] x = new double[3];
        for (i = 0; i < 3; ++i) {
            x[i] = RandMrg.multModM(A[i][0], s[0], 0.0, m);
            x[i] = RandMrg.multModM(A[i][1], s[1], x[i], m);
            x[i] = RandMrg.multModM(A[i][2], s[2], x[i], m);
        }
        for (i = 0; i < 3; ++i) {
            v[i] = x[i];
        }
    }

    private static void matMatModM(double[][] A, double[][] B, double[][] C, double m) {
        int j;
        int i;
        double[] V = new double[3];
        double[][] W = new double[3][3];
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                V[j] = B[j][i];
            }
            RandMrg.matVecModM(A, V, V, m);
            for (j = 0; j < 3; ++j) {
                W[j][i] = V[j];
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                C[i][j] = W[i][j];
            }
        }
    }

    private static void matTwoPowModM(double[][] A, double[][] B, double m, int e) {
        int i;
        if (A != B) {
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    B[i][j] = A[i][j];
                }
            }
        }
        for (i = 0; i < e; ++i) {
            RandMrg.matMatModM(B, B, B, m);
        }
    }

    private static void matPowModM(double[][] A, double[][] B, double m, int c) {
        int j;
        int n = c;
        double[][] W = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                W[i][j] = A[i][j];
                B[i][j] = 0.0;
            }
        }
        for (j = 0; j < 3; ++j) {
            B[j][j] = 1.0;
        }
        while (n > 0) {
            if (n % 2 == 1) {
                RandMrg.matMatModM(W, B, B, m);
            }
            RandMrg.matMatModM(W, W, W, m);
            n /= 2;
        }
    }

    private double U01() {
        int k;
        double p1 = 1403580.0 * this.Cg[1] - 810728.0 * this.Cg[0];
        if ((p1 -= (double)(k = (int)(p1 / 4.294967087E9)) * 4.294967087E9) < 0.0) {
            p1 += 4.294967087E9;
        }
        this.Cg[0] = this.Cg[1];
        this.Cg[1] = this.Cg[2];
        this.Cg[2] = p1;
        double p2 = 527612.0 * this.Cg[5] - 1370589.0 * this.Cg[3];
        if ((p2 -= (double)(k = (int)(p2 / 4.294944443E9)) * 4.294944443E9) < 0.0) {
            p2 += 4.294944443E9;
        }
        this.Cg[3] = this.Cg[4];
        this.Cg[4] = this.Cg[5];
        this.Cg[5] = p2;
        double u = p1 > p2 ? (p1 - p2) * 2.328306549295728E-10 : (p1 - p2 + 4.294967087E9) * 2.328306549295728E-10;
        return this.anti ? 1.0 - u : u;
    }

    private double U01d() {
        double u = this.U01();
        if (this.anti) {
            return (u += (this.U01() - 1.0) * 5.960464477539063E-8) < 0.0 ? u + 1.0 : u;
        }
        return (u += this.U01() * 5.960464477539063E-8) < 1.0 ? u : u - 1.0;
    }

    public RandMrg() {
        int i;
        for (int i2 = 0; i2 < 6; ++i2) {
            this.Cg[i2] = this.Ig[i2] = nextSeed[i2];
            this.Bg[i2] = this.Ig[i2];
        }
        RandMrg.matVecModM(A1p127, nextSeed, nextSeed, 4.294967087E9);
        double[] temp = new double[3];
        for (i = 0; i < 3; ++i) {
            temp[i] = nextSeed[i + 3];
        }
        RandMrg.matVecModM(A2p127, temp, temp, 4.294944443E9);
        for (i = 0; i < 3; ++i) {
            RandMrg.nextSeed[i + 3] = temp[i];
        }
    }

    public RandMrg(String name) {
        this();
        this.descriptor = name;
    }

    public static void setPackageSeed(long[] seed) {
        if (seed.length != 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (seed[0] == 0L && seed[1] == 0L && seed[2] == 0L) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (seed[5] == 0L && seed[3] == 0L && seed[4] == 0L) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        long m1 = 0xFFFFFF2FL;
        if (seed[0] >= 0xFFFFFF2FL || seed[1] >= 0xFFFFFF2FL || seed[2] >= 0xFFFFFF2FL) {
            throw new IllegalArgumentException("The first 3 values must be less than 4294967087");
        }
        long m2 = 4294944443L;
        if (seed[5] >= 4294944443L || seed[3] >= 4294944443L || seed[4] >= 4294944443L) {
            throw new IllegalArgumentException("The last 3 values must be less than 4294944443");
        }
        for (int i = 0; i < 6; ++i) {
            RandMrg.nextSeed[i] = seed[i];
        }
    }

    public void resetStartStream() {
        for (int i = 0; i < 6; ++i) {
            this.Cg[i] = this.Bg[i] = this.Ig[i];
        }
    }

    public void resetStartSubstream() {
        for (int i = 0; i < 6; ++i) {
            this.Cg[i] = this.Bg[i];
        }
    }

    public void resetNextSubstream() {
        int i;
        RandMrg.matVecModM(A1p76, this.Bg, this.Bg, 4.294967087E9);
        double[] temp = new double[3];
        for (i = 0; i < 3; ++i) {
            temp[i] = this.Bg[i + 3];
        }
        RandMrg.matVecModM(A2p76, temp, temp, 4.294944443E9);
        for (i = 0; i < 3; ++i) {
            this.Bg[i + 3] = temp[i];
        }
        for (i = 0; i < 6; ++i) {
            this.Cg[i] = this.Bg[i];
        }
    }

    public void increasedPrecis(boolean incp) {
        this.prec53 = incp;
    }

    public void setAntithetic(boolean anti) {
        this.anti = anti;
    }

    public void advanceState(int e, int c) {
        int i;
        double[][] B1 = new double[3][3];
        double[][] C1 = new double[3][3];
        double[][] B2 = new double[3][3];
        double[][] C2 = new double[3][3];
        if (e > 0) {
            RandMrg.matTwoPowModM(A1p0, B1, 4.294967087E9, e);
            RandMrg.matTwoPowModM(A2p0, B2, 4.294944443E9, e);
        } else if (e < 0) {
            RandMrg.matTwoPowModM(InvA1, B1, 4.294967087E9, -e);
            RandMrg.matTwoPowModM(InvA2, B2, 4.294944443E9, -e);
        }
        if (c >= 0) {
            RandMrg.matPowModM(A1p0, C1, 4.294967087E9, c);
            RandMrg.matPowModM(A2p0, C2, 4.294944443E9, c);
        } else {
            RandMrg.matPowModM(InvA1, C1, 4.294967087E9, -c);
            RandMrg.matPowModM(InvA2, C2, 4.294944443E9, -c);
        }
        if (e != 0) {
            RandMrg.matMatModM(B1, C1, C1, 4.294967087E9);
            RandMrg.matMatModM(B2, C2, C2, 4.294944443E9);
        }
        RandMrg.matVecModM(C1, this.Cg, this.Cg, 4.294967087E9);
        double[] cg3 = new double[3];
        for (i = 0; i < 3; ++i) {
            cg3[i] = this.Cg[i + 3];
        }
        RandMrg.matVecModM(C2, cg3, cg3, 4.294944443E9);
        for (i = 0; i < 3; ++i) {
            this.Cg[i + 3] = cg3[i];
        }
    }

    public void setSeed(long[] seed) {
        if (seed.length != 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (seed[0] == 0L && seed[1] == 0L && seed[2] == 0L) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (seed[3] == 0L && seed[4] == 0L && seed[5] == 0L) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        long m1 = 0xFFFFFF2FL;
        if (seed[0] >= 0xFFFFFF2FL || seed[1] >= 0xFFFFFF2FL || seed[2] >= 0xFFFFFF2FL) {
            throw new IllegalArgumentException("The first 3 values must be less than 4294967087");
        }
        long m2 = 4294944443L;
        if (seed[3] >= 4294944443L || seed[4] >= 4294944443L || seed[5] >= 4294944443L) {
            throw new IllegalArgumentException("The last 3 values must be less than 4294944443");
        }
        for (int i = 0; i < 6; ++i) {
            this.Bg[i] = this.Ig[i] = (double)seed[i];
            this.Cg[i] = this.Ig[i];
        }
    }

    public double[] getState() {
        return this.Cg;
    }

    public String toString() {
        PrintfFormat str = new PrintfFormat();
        str.append("The current state of the RandMrg");
        if (this.descriptor != null && this.descriptor.length() > 0) {
            str.append(" " + this.descriptor);
        }
        str.append(":" + PrintfFormat.NEWLINE + "   Cg = { ");
        for (int i = 0; i < 5; ++i) {
            str.append((long)this.Cg[i] + ", ");
        }
        str.append((long)this.Cg[5] + " }" + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return str.toString();
    }

    public String toStringFull() {
        int i;
        PrintfFormat str = new PrintfFormat();
        str.append("The RandMrg");
        if (this.descriptor != null && this.descriptor.length() > 0) {
            str.append(" " + this.descriptor);
        }
        str.append(":" + PrintfFormat.NEWLINE + "   anti = " + (this.anti ? "true" : "false")).append(PrintfFormat.NEWLINE);
        str.append("   Ig = { ");
        for (i = 0; i < 5; ++i) {
            str.append((long)this.Ig[i] + ", ");
        }
        str.append((long)this.Ig[5] + " }" + PrintfFormat.NEWLINE);
        str.append("   Bg = { ");
        for (i = 0; i < 5; ++i) {
            str.append((long)this.Bg[i] + ", ");
        }
        str.append((long)this.Bg[5] + " }" + PrintfFormat.NEWLINE);
        str.append("   Cg = { ");
        for (i = 0; i < 5; ++i) {
            str.append((long)this.Cg[i] + ", ");
        }
        str.append((long)this.Cg[5] + " }" + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return str.toString();
    }

    public double nextDouble() {
        if (this.prec53) {
            return this.U01d();
        }
        return this.U01();
    }

    public void nextArrayOfDouble(double[] u, int start, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive.");
        }
        for (int i = start; i < start + n; ++i) {
            u[i] = this.nextDouble();
        }
    }

    public int nextInt(int i, int j) {
        return i + (int)(this.nextDouble() * ((double)(j - i) + 1.0));
    }

    public void nextArrayOfInt(int i, int j, int[] u, int start, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive.");
        }
        for (int k = start; k < start + n; ++k) {
            u[k] = this.nextInt(i, j);
        }
    }

    public RandMrg clone() {
        RandMrg retour = null;
        try {
            retour = (RandMrg)super.clone();
            retour.Cg = new double[6];
            retour.Bg = new double[6];
            retour.Ig = new double[6];
            for (int i = 0; i < 6; ++i) {
                retour.Cg[i] = this.Cg[i];
                retour.Bg[i] = this.Bg[i];
                retour.Ig[i] = this.Ig[i];
            }
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace(System.err);
        }
        return retour;
    }
}

