% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_cat_levels.R
\name{filterLevels}
\alias{filterLevels}
\title{Filter data by levels of a categorical variables}
\usage{
filterLevels(.data, var, levels)
}
\arguments{
\item{.data}{a dataframe to filter}

\item{var}{character of the column in \code{.data} to filter by}

\item{levels}{a character vector of levels in \code{var} to filter by}
}
\value{
filtered dataframe with tidyverse code attached
}
\description{
Filter a dataframe by some levels of one categorical variable
and returns the result along with tidyverse code used to generate it.
}
\examples{
filtered <- filterLevels(iris, var = "Species",
    levels = c("versicolor", "virginica"))
cat(code(filtered))
head(filtered)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
