% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ispca.cv.R
\name{ispca.cv}
\alias{ispca.cv}
\title{Cross-validation for ispca}
\usage{
ispca.cv(x, L, K = 5, mu1, mu2, eps = 1e-04, pen1 = "homogeneity",
  pen2 = "magnitude", scale.x = TRUE, maxstep = 50)
}
\arguments{
\item{x}{list of data matrices, L datasets of explanatory variables.}

\item{L}{numeric, number of datasets.}

\item{K}{numeric, number of cross-validation folds. Default is 5.}

\item{mu1}{numeric, the feasible set of sparsity penalty parameter.}

\item{mu2}{numeric, the feasible set of contrasted penalty parameter.}

\item{eps}{numeric, the threshold at which the algorithm terminates.}

\item{pen1}{character, "homogeneity" or "heterogeneity" type of the sparsity structure. If not specified, the default is homogeneity.}

\item{pen2}{character, "magnitude" or "sign" based contrasted penalty. If not specified, the default is magnitude.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}

\item{maxstep}{numeric, maximum iteration steps. The default value is 50.}
}
\value{
An 'isca.cv' object that contains the list of the following items.
\itemize{
\item{x:}{ list of data matrices, L datasets of explanatory variables with centered columns. If scale.x is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{y:}{ list of data matrices, L datasets of dependent variables with centered columns. If scale.y is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{mu1:}{ the sparsity penalty parameter selected from the feasible set of parameter mu1 provided by users.}
\item{mu2:}{ the contrasted penalty parameter selected from the feasible set of parameter mu2 provided by users.}
\item{fold:}{ The fold assignments for cross-validation for each observation.}
\item{eigenvalue:}{ the estimated first eigenvalue with selected tuning parameters mu1 and mu2.}
\item{eigenvector:}{ the estimated first eigenvector with selected tuning parameters mu1 and mu2.}
\item{component:}{ the estimated first component with selected tuning parameters mu1 and mu2.}
\item{variable:}{ the screening results of variables.}
\item{meanx:}{ list of numeric vectors, column mean of the original datasets x.}
\item{normx:}{ list of numeric vectors, column standard deviation of the original datasets x.}
}
}
\description{
Performs K-fold cross validation for the integrative sparse principal component analysis over a grid of values for the regularization parameter mu1 and mu2.
}
\examples{
\donttest{
# Load a list with 3 data sets
library(iSFun)
data("simData.pca")
x <- simData.pca$x
L <- length(x)
mu1 <- c(0.3, 0.5)
mu2 <- 0.002

res_homo_m <- ispca.cv(x = x, L = L, K = 5, mu1 = mu1, mu2 = mu2,
                       pen1 = "homogeneity", pen2 = "magnitude", scale.x = TRUE, maxstep = 50)

res_homo_s <- ispca.cv(x = x, L = L, K = 5, mu1 = mu1, mu2 = mu2,
                       pen1 = "homogeneity", pen2 = "sign", scale.x = TRUE, maxstep = 50)

mu1 <- c(0.1, 0.2)
mu2 <- 0.05
res_hete_m <- ispca.cv(x = x, L = L, K = 5, mu1 = mu1, mu2 = mu2,
                       pen1 = "heterogeneity", pen2 = "magnitude", scale.x = TRUE, maxstep = 50)

res_hete_s <- ispca.cv(x = x, L = L, K = 5, mu1 = mu1, mu2 = mu2,
                       pen1 = "heterogeneity", pen2 = "sign", scale.x = TRUE, maxstep = 50)
}
}
\references{
\itemize{
\item{Fang K, Fan X, Zhang Q, et al. Integrative sparse principal component analysis[J]. Journal of Multivariate Analysis, 2018, 166: 1-16.}
}
}
\seealso{
See Also as \code{\link{ispca}}.
}
