% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaitrees.R
\name{variable_importance_similarity}
\alias{variable_importance_similarity}
\title{Calculate similarity between the final tree in a tree learner with all trees
in new tree learner using variable importance scores.}
\usage{
variable_importance_similarity(lnr, new_lnr, ...)
}
\arguments{
\item{lnr}{The original learner}

\item{new_lnr}{The new learner}

\item{...}{Additional arguments (refer to Julia documentation)}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.0.0/IAITrees/reference/#IAI.variable_importance_similarity}{\code{variable_importance_similarity}}
}
\section{IAI Compatibility}{

Requires IAI version 2.2 or higher.
}

\examples{
\dontrun{iai::variable_importance_similarity(lnr, new_lnr)}

}
