% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/karyogram.R
\name{karyoDiploid}
\alias{karyoDiploid}
\title{Diploid karyogram}
\usage{
karyoDiploid(
  paternal,
  maternal,
  chrom = 1:22,
  col = c(paternal = "lightblue", maternal = "orange"),
  alpha = 1,
  bgcol = "gray95",
  title = NULL
)
}
\arguments{
\item{paternal, maternal}{data.frames (or objects coercible to data.frames)
containing the segments to be shown on the paternal and maternal strands of
the karyogram. The first three columns must contain chromosome (with or
without "chr" prefix), start position and stop position (in Mb). Column
names are ignored, as well as any further columns.}

\item{chrom}{The (autosomal) chromosomes to be included in the plot,
given as a subset of the integers 1, 2,..., 22.}

\item{col}{A vector of two colours (in any form recognisable by R). If only
one colour is given it is recycled. If the vector is named, a colour legend
is included in the plot, using the names as labels.}

\item{alpha}{A single numeric in \verb{[0,1]} indicating colour transparency.}

\item{bgcol}{The background colour of the chromosomes.}

\item{title}{Plot title.}
}
\value{
The plot object is returned invisibly, so that additional ggplot
layers may be added if needed.
}
\description{
Show chromosomal segments in a diploid karyogram
}
\examples{

\dontrun{
pat = data.frame(chrom = c(1,4,5,5,10,10), start = c(100,50,20,80,10,80),
                 end = c(120,100,25,100,70,120))
mat = data.frame(chrom = c(2,4,5,5,10), start = c(80,50,10,80,50),
                 end = c(120,100,35,100,120))
karyoDiploid(pat, mat)
}


}
