% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/karyogram.R
\name{karyoHaploid}
\alias{karyoHaploid}
\title{Haploid karyogram}
\usage{
karyoHaploid(
  segments,
  chrom = 1:22,
  colBy = NULL,
  col = NULL,
  separate = TRUE,
  alpha = 1,
  bgcol = "gray92",
  title = NULL,
  legendTitle = NULL,
  base_size = 16
)
}
\arguments{
\item{segments}{A data.frame (or an object coercible to data.frame)
containing the segments to be shown on the karyogram. The first three
columns must contain chromosome (with or without "chr" prefix), start
position and stop position (in Mb). Any further columns are ignored, except
possibly a column indicated by \code{colBy}.}

\item{chrom}{A vector indicating which chromosomes to include.}

\item{colBy}{A character vector naming the columns to be used for colouring.
If NULL (default), all segments have the same colour.}

\item{col}{A single fill colour for all the segments, or (if \code{colBy} is used)
a named vector of colours. In the latter case, the names should include all
entries in the \code{colBy} column.}

\item{separate}{A logical; relevant only if the \code{colBy} column has more than
one level. If FALSE, all segments are drawn in full height. This may not be
optimal if segments of different colours overlap. If TRUE the levels are
drawn in separate bands on the chromosomes.}

\item{alpha}{A single numeric in \verb{[0,1]} indicating colour transparency.}

\item{bgcol}{The background colour of the chromosomes.}

\item{title}{Plot title.}

\item{legendTitle}{Legend title.}

\item{base_size}{Font size, passed onto \code{ggplot2::theme()}.}
}
\value{
The plot object is returned invisibly, so that additional \code{ggplot}
layers may be added if needed.
}
\description{
Show chromosomal segments in a haploid karyogram
}
\examples{

\dontrun{
segs = data.frame(chrom = c(1,4,5,5,10,10),
                  start = c(100,50,20,80,10,50),
                  end = c(120,100,25,100,70,120),
                  IBD = c("paternal","maternal"))
cols = c(paternal = "blue", maternal = "red")

karyoHaploid(segs, col = "cyan")
karyoHaploid(segs, colBy = "IBD", col = cols)

# Note difference if `separate = FALSE`
karyoHaploid(segs, colBy = "IBD", col = cols, separate = FALSE)

# Reduce alpha to see the overlaps:
karyoHaploid(segs, colBy = "IBD", col = cols, separate = FALSE, alpha = 0.7)

}

}
