% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{subset_icd}
\alias{[.icd10}
\alias{[.icd9}
\alias{[[.icd10}
\alias{[[.icd9}
\alias{subset_icd}
\title{extract subset from ICD data}
\usage{
\method{[}{icd9}(x, ...)

\method{[[}{icd9}(x, ...)

\method{[}{icd10}(x, ...)

\method{[[}{icd10}(x, ...)
}
\arguments{
\item{x}{input data with list, vector, factor, and class set to an ICD type.}

\item{...}{arguments passed on to other functions}
}
\description{
exactly the same as using x[n] or x[[n]] but preserves the ICD classes in
result
}
\examples{
x <- as.icd9(list(my_codes = c("V10.1", "441.1")))
x[1]
x[[1]]
x[[1]][2]
# subsetting a list should give the underlying data structure type,
# preserving the ICD class
stopifnot(!inherits(x[[1]], "list"))
stopifnot(!inherits(x[[1]][2], "list"))

y <- as.icd10(c("A01", "B0234"))
y[2]
y[[2]]
stopifnot(inherits(y[2], "icd10"))
stopifnot(inherits(y[[2]], "icd10"))
}

