% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{icd10_comorbid_parent_search_cpp}
\alias{icd10_comorbid_parent_search_cpp}
\title{Internal function to find ICD-10 parents}
\usage{
icd10_comorbid_parent_search_cpp(x, map, visit_name, icd_name)
}
\arguments{
\item{x}{Character vector (not factor)}

\item{map}{named list containing vectors of ICD-9 codes. E.g. the AHRQ ICD-9
comorbidities, contains \code{list(OBESE = c("2780", "27800", "27801",
"27803", "V8554", "79391", "64910", "64911", "64912", "64913", "64914",
"V8530", "V8531", "V8532", "V8533", "V8534", "V8535", "V8536", "V8537",
"V8538", "V8539", "V8541", "V8542", "V8543", "V8544", "V8545" ), DEPRESS =
c("3004", "30112", "3090", "3091", "311"))} amongst other longer groups.}

\item{visit_name}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visit_id}
was not specified, then the first column of the data frame is used.}

\item{icd_name}{The column in the \code{data.frame} which contains the ICD
codes. This is a character vector of length one. If it is \code{NULL},
\code{icd9} will attempt to guess the column name, looking for
progressively less likely possibilities until it matches a single column.
Failing this, it will take the first column in the data frame. Specifying
the column using this argument avoids the guesswork.}
}
\description{
Written in C++ for speed. There are no default arguments and there is no
value guessing.
}
\seealso{
\url{https://github.com/s-u/fastmatch/blob/master/src/fastmatch.c}
}
\keyword{internal}

