% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/condense.R
\name{icd9Condense}
\alias{icd9Condense}
\alias{icd9CondenseDecimal}
\alias{icd9CondenseShort}
\title{Condense ICD-9 code by replacing complete families with parent codes}
\usage{
icd9Condense(icd9, isShort = icd9GuessIsShort(icd9), onlyReal = NULL,
  warn = TRUE)

icd9CondenseDecimal(icd9Decimal, onlyReal = NULL, warn = TRUE)

icd9CondenseShort(icd9Short, onlyReal = NULL, warn = TRUE,
  keepFactorLevels = FALSE)
}
\arguments{
\item{icd9}{is
a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{onlyReal}{single logical value, if TRUE, will limit the search to those
codes which appear in the master list, not just syntactically valid codes.
Since nearly valid, out-dated or new codes may be missed, not limiting to
'real' values will be useful. Ultimately, there will need to be annual (and
all-time) master lists of codes and the ability to test against a given
master list given the year of the ICD-9 coding.}

\item{warn}{single logical value, if \code{TRUE}, give warnings when
there is discrepancy between \code{onlyReal} being \code{TRUE} yet data
containing undefined codes.}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than
five characters is given in a code, then the digits are greedily assigned
to hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{keepFactorLevels}{single logical value, default \code{FALSE}. If
\code{TRUE}, will reuse the factor levels from the input data for the
output data. This only applies if a factor is given for the input codes.}
}
\description{
This can be thought of as the inverse operation to
  \code{icd9Children}.
}
\seealso{
Other ICD-9 ranges: \code{\link{\%i9d\%}},
  \code{\link{\%i9da\%}}, \code{\link{\%i9mj\%}},
  \code{\link{\%i9s\%}}, \code{\link{\%i9sa\%}},
  \code{\link{icd9ExpandRange}},
  \code{\link{icd9ExpandRangeDecimal}},
  \code{\link{icd9ExpandRangeMajor}},
  \code{\link{icd9ExpandRangeShort}};
  \code{\link{icd9Children}}, \code{\link{icd9Children}},
  \code{\link{icd9ChildrenDecimal}},
  \code{\link{icd9ChildrenShort}};
  \code{\link{icd9ExpandMinor}}
}

