% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icpower.val}
\alias{icpower.val}
\title{Study design in the presence of error-prone diagnostic tests and
self-reported outcomes when sensitivity and specificity are unkonwn and a
validation set is used}
\usage{
icpower.val(HR, sensitivity, specificity, survivals, N = NULL, power = NULL,
  rhoval, rho = 0.5, alpha = 0.05, pmiss = 0, design = "MCAR",
  designval = "MCAR", negpred = 1)
}
\arguments{
\item{HR}{hazard ratio under the alternative hypothesis.}

\item{sensitivity}{the sensitivity of test.}

\item{specificity}{the specificity of test}

\item{survivals}{a vector of survival function at each test time for
baseline(reference) group. Its length determines the number of tests.}

\item{N}{a vector of sample sizes to calculate corresponding powers. If one
needs to calculate sample size, then set to NULL.}

\item{power}{a vector of powers to calculate corresponding sample sizes. If
one needs to calculate power, then set to NULL.}

\item{rhoval}{proportion of subjects in validation set.}

\item{rho}{proportion of subjects in baseline(reference) group.}

\item{alpha}{type I error.}

\item{pmiss}{a value or a vector (must have same length as survivals) of the
probabilities of each test being randomly missing at each test time. If
pmiss is a single value, then each test is assumed to have an identical
probability of missingness.}

\item{design}{missing mechanism: "MCAR" or "NTFP".}

\item{designval}{missing mechanism of validation set: "MCAR" or "NTFP".}

\item{negpred}{baseline negative predictive value, i.e. the probability of
  being truely disease free for those who were tested (reported) as disease
  free at baseline. If baseline screening test is perfect, then negpred = 1.}
}
\value{
\itemize{ \item result: a data frame with calculated sample size and
power \item IR1 and IR2: calculated unit Fisher information matrices for each
group in non-validation set \item IV1 and IV2: calculated unit Fisher
information matrices for each group in validation set }
}
\description{
This function calculates the power and sample size in the presence of
error-prone diagnostic tests and self-reported outcomes when both sensitivity
and specificity are unknown. In this case, a subject of the subjects receive
both gold standard test and error-prone test at each non-missing visit. The
remaining subjects receive only error-prone test. Here, for the validation
set, NTFP refers to no test after first positive result from the gold
standard test. Both sensitivity and specificity are treated as unknown
parameters in this setting.
}
\examples{
surv <- exp(log(0.9)*(1:8)/8)
pow <- icpower.val(HR = 2, sensitivity = 0.55, specificity = 0.99,
   survivals = surv, power = 0.9, rhoval=0.05, design= "NTFP", designval = "NTFP")
pow$result
}

