% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fpa.R
\name{Fpa}
\alias{Fpa}
\title{Fpa from Flim}
\usage{
Fpa(Flim, sigmaF)
}
\arguments{
\item{Flim}{the value of the Flim reference point.}

\item{sigmaF}{the estimation uncertainty in F (standard error of logF in the
terminal year).}
}
\value{
Value of Fpa.
}
\description{
Calculate the value of Fpa from Flim and sigmaF.
}
\note{
The purpose of PA reference points is to apply a precautionary approach in
fisheries management.

By comparing the current F to Fpa, one can answer the question: are we at
least 95\% sure that F is below Flim, given the estimation uncertainty?

The ICES (2017) technical guidelines define Fpa as:

\deqn{F_\mathrm{pa} = F_\mathrm{lim} \exp(-1.645\sigma_F)}{
      Fpa = Flim * exp(-1.645*sigmaF)}

The \code{Fpa} function can also be used to calculate reference points based
on harvest rate: Hpa from Hlim and sigmaH.
}
\examples{
Fpa(0.90, 0.15)

}
\references{
ICES (2017) ICES fisheries management reference points for category 1 and 2
stocks.
\href{http://ices.dk/sites/pub/Publication\%20Reports/Advice/2017/2017/12.04.03.01_Reference_points_for_category_1_and_2.pdf}{\emph{ICES
Advice Technical Guidelines 12.4.3.1}}.
}
\seealso{
\code{\link{Bpa}} calculates that reference point from Blim and sigmaB.

\code{\link{sigmaPA}} calculates the implicit sigma from PA reference points.

\code{\link{icesAdvice-package}} gives an overview of the package.
}
\author{
Arni Magnusson.
}
