% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStockStatusValues.R
\name{getStockStatusValues}
\alias{getStockStatusValues}
\title{Get the Values in a Stock Status Table}
\usage{
getStockStatusValues(assessmentKey, ...)
}
\arguments{
\item{assessmentKey}{the unique identifier of the stock assessment}

\item{...}{arguments passed to \code{\link{ices_get}}.}
}
\value{
A data frame.
}
\description{
Get summary results of historical stock size, recruitment, and fishing
pressure.
}
\examples{
\dontrun{
assessmentKey <- findAssessmentKey("had.27.46a20", year = 2022)
status <- getStockStatusValues(assessmentKey)
status
}

}
\seealso{
\code{\link{getSAG}} supports querying many years and quarters in one
  function call.

\code{\link{getListStocks}} and \code{\link{getFishStockReferencePoints}} get
  a list of stocks and reference points.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Colin Millar.
}
